/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.PSet_ReifStore_RDB;
import com.hp.hpl.jena.db.impl.ReificationCache;
import com.hp.hpl.jena.db.impl.ReificationCacheMap;
import com.hp.hpl.jena.db.impl.ReificationStatementMask;
import com.hp.hpl.jena.db.impl.ResultSetReifIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphBase;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedGraphReifier_RDB
extends SpecializedGraphBase
implements SpecializedGraphReifier {
    public PSet_ReifStore_RDB m_pset;
    public DBPropLSet m_dbPropLSet;
    public IDBID my_GID = null;
    private ReificationCacheMap m_reifCache;
    public PSet_ReifStore_RDB m_reif;

    SpecializedGraphReifier_RDB(DBPropLSet lProp, IPSet pSet, Integer dbGraphID) {
        this.m_pset = (PSet_ReifStore_RDB)pSet;
        this.m_dbPropLSet = lProp;
        this.my_GID = new DBIDInt(dbGraphID);
        this.m_reifCache = new ReificationCacheMap(this, 1);
        this.m_reif = this.m_pset;
    }

    public SpecializedGraphReifier_RDB(IPSet pSet, Integer dbGraphID) {
        this.m_pset = (PSet_ReifStore_RDB)pSet;
        this.my_GID = new DBIDInt(dbGraphID);
        this.m_reifCache = new ReificationCacheMap(this, 1);
        this.m_reif = this.m_pset;
    }

    @Override
    public void add(Node n, Triple t, SpecializedGraph.CompletionFlag complete) throws CannotReifyException {
        ReificationStatementMask same = new ReificationStatementMask();
        ReificationStatementMask diff = new ReificationStatementMask();
        ReificationCache rs = this.m_reifCache.load(n, t, same, diff);
        if (rs == null) {
            this.m_reif.storeReifStmt(n, t, this.my_GID);
        } else if (diff.hasNada()) {
            boolean didUpdate = false;
            if (!same.hasSubj()) {
                Triple st = Triple.create(n, RDF.Nodes.subject, t.getSubject());
                this.m_reif.updateFrag(n, st, new ReificationStatementMask(st), this.my_GID);
                didUpdate = true;
            }
            if (!same.hasPred()) {
                Triple pt = Triple.create(n, RDF.Nodes.predicate, t.getPredicate());
                this.m_reif.updateFrag(n, pt, new ReificationStatementMask(pt), this.my_GID);
                didUpdate = true;
            }
            if (!same.hasObj()) {
                Triple ot = Triple.create(n, RDF.Nodes.object, t.getObject());
                this.m_reif.updateFrag(n, ot, new ReificationStatementMask(ot), this.my_GID);
                didUpdate = true;
            }
            if (!rs.mask.hasType()) {
                Triple tt = Triple.create(n, RDF.Nodes.type, RDF.Nodes.Statement);
                this.m_reif.updateFrag(n, tt, new ReificationStatementMask(tt), this.my_GID);
                didUpdate = true;
            }
            if (didUpdate) {
                this.fragCompact(n);
            }
            this.m_reifCache.flushAll();
        } else {
            if (rs.mask.isStmt()) {
                throw new AlreadyReifiedException(n);
            }
            throw new CannotReifyException(n);
        }
        complete.setDone();
    }

    @Override
    public void delete(Node n, Triple t, SpecializedGraph.CompletionFlag complete) {
        this.m_reifCache.flushAll();
        this.m_reif.deleteReifStmt(n, t, this.my_GID);
        complete.setDone();
    }

    @Override
    public boolean contains(Node n, Triple t, SpecializedGraph.CompletionFlag complete) {
        throw new JenaException("SpecializedGraphReifier.contains called");
    }

    @Override
    public ExtendedIterator<Node> findReifiedNodes(Triple t, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_reif.findReifStmtURIByTriple(t, this.my_GID);
    }

    @Override
    public Triple findReifiedTriple(Node n, SpecializedGraph.CompletionFlag complete) {
        ResultSetReifIterator it = this.m_reif.findReifStmt(n, true, this.my_GID, false);
        Triple res = null;
        if (it.hasNext()) {
            res = (Triple)it.next();
        }
        complete.setDone();
        return res;
    }

    public ExtendedIterator<Triple> findReifiedTriples(Node n, SpecializedGraph.CompletionFlag complete) {
        complete.setDone();
        return this.m_reif.findReifStmt(n, false, this.my_GID, true);
    }

    @Override
    public void add(Graph g, SpecializedGraph.CompletionFlag complete) {
        throw new AddDeniedException("sorry, not implemented");
    }

    @Override
    public void add(Triple frag, SpecializedGraph.CompletionFlag complete) throws AlreadyReifiedException {
        ReificationStatementMask fragMask = new ReificationStatementMask(frag);
        if (fragMask.hasNada()) {
            return;
        }
        boolean fragHasType = fragMask.hasType();
        Node stmtURI = frag.getSubject();
        ReificationCache cachedFrag = this.m_reifCache.load(stmtURI);
        if (cachedFrag == null) {
            this.m_reif.storeFrag(stmtURI, frag, fragMask, this.my_GID);
            complete.setDone();
        } else {
            ReificationStatementMask cachedMask = cachedFrag.getStmtMask();
            if (cachedMask.hasIntersect(fragMask)) {
                ResultSetReifIterator it;
                boolean dup;
                boolean bl = dup = fragHasType && cachedMask.hasType();
                if (!dup && !(dup = (it = this.m_reif.findFrag(stmtURI, frag, fragMask, this.my_GID)).hasNext())) {
                    if (cachedMask.isStmt()) {
                        throw new AlreadyReifiedException(frag.getSubject());
                    }
                    this.m_reif.storeFrag(stmtURI, frag, fragMask, this.my_GID);
                    this.m_reifCache.flush(cachedFrag);
                }
            } else if (cachedFrag.canMerge(fragMask)) {
                if (cachedFrag.canUpdate(fragMask)) {
                    this.m_reif.updateFrag(stmtURI, frag, fragMask, this.my_GID);
                    cachedFrag.update(fragMask);
                } else {
                    this.fragCompact(stmtURI);
                }
            } else {
                this.m_reif.storeFrag(stmtURI, frag, fragMask, this.my_GID);
            }
        }
        complete.setDone();
    }

    @Override
    public void delete(Triple frag, SpecializedGraph.CompletionFlag complete) {
        ReificationStatementMask fragMask = new ReificationStatementMask(frag);
        if (fragMask.hasNada()) {
            return;
        }
        Node stmtURI = frag.getSubject();
        ResultSetReifIterator it = this.m_reif.findFrag(stmtURI, frag, fragMask, this.my_GID);
        if (it.hasNext()) {
            if (it.getFragCount() == 1) {
                this.m_reif.deleteFrag(frag, fragMask, this.my_GID);
                it.close();
            } else {
                this.m_reif.nullifyFrag(stmtURI, fragMask, this.my_GID);
                it.close();
                this.fragCompact(stmtURI);
            }
            ReificationCache cachedFrag = this.m_reifCache.lookup(stmtURI);
            if (cachedFrag != null) {
                this.m_reifCache.flush(cachedFrag);
            }
        }
        complete.setDone();
    }

    protected void fragCompact(Node stmtURI) {
        ResultSetReifIterator itHasType = this.m_reif.findReifStmt(stmtURI, true, this.my_GID, false);
        if (itHasType.hasNext()) {
            Triple t = (Triple)itHasType.next();
            if (itHasType.hasNext()) {
                throw new JenaException("Multiple HasType fragments for URI");
            }
            ReificationStatementMask htMask = new ReificationStatementMask(t);
            itHasType.close();
            ResultSetReifIterator itFrag = this.m_reif.findReifStmt(stmtURI, false, this.my_GID, false);
            ReificationStatementMask upMask = new ReificationStatementMask();
            while (itFrag.hasNext()) {
                t = (Triple)itFrag.next();
                if (itFrag.getHasType()) continue;
                ReificationStatementMask fm = new ReificationStatementMask(this.rowToFrag(stmtURI, t));
                if (htMask.hasIntersect(fm)) break;
                this.m_reif.updateFrag(stmtURI, t, fm, this.my_GID);
                htMask.setMerge(fm);
                this.m_reif.deleteFrag(t, fm, this.my_GID);
            }
        }
    }

    protected Triple rowToFrag(Node stmtURI, Triple row) {
        Node pred = null;
        Node obj = null;
        int valCnt = 0;
        if (row.getSubject() != null) {
            obj = row.getSubject();
            pred = RDF.Nodes.subject;
            ++valCnt;
        }
        if (row.getPredicate() != null) {
            obj = row.getPredicate();
            pred = RDF.Nodes.predicate;
            ++valCnt;
        }
        if (row.getObject() != null) {
            obj = row.getObject();
            pred = RDF.Nodes.object;
            ++valCnt;
        }
        if (valCnt != 1) {
            throw new JenaException("Partially reified row must have exactly one value");
        }
        return Triple.create(stmtURI, pred, obj);
    }

    @Override
    public void add(List<Triple> triples, SpecializedGraph.CompletionFlag complete) {
        ArrayList<Triple> remainingTriples = new ArrayList<Triple>();
        for (int i = 0; i < triples.size(); ++i) {
            SpecializedGraph.CompletionFlag partialResult = this.newComplete();
            this.add(triples.get(i), partialResult);
            if (partialResult.isDone()) continue;
            remainingTriples.add(triples.get(i));
        }
        triples.clear();
        if (remainingTriples.isEmpty()) {
            complete.setDone();
        } else {
            triples.addAll(remainingTriples);
        }
    }

    @Override
    public void delete(List<Triple> triples, SpecializedGraph.CompletionFlag complete) {
        boolean result = true;
        Iterator<Triple> it = triples.iterator();
        while (it.hasNext()) {
            SpecializedGraph.CompletionFlag partialResult = this.newComplete();
            this.delete(it.next(), partialResult);
            result = result && partialResult.isDone();
        }
        if (result) {
            complete.setDone();
        }
    }

    @Override
    public int tripleCount() {
        ExtendedIterator<Triple> it = this.find(null, null, null, this.newComplete());
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        it.close();
        return count;
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch t, SpecializedGraph.CompletionFlag complete) {
        ResultSetReifIterator it = this.m_reif.findReifTripleMatch(t, this.my_GID);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Triple t, SpecializedGraph.CompletionFlag complete) {
        ExtendedIterator<Triple> it = this.find(t, complete);
        try {
            boolean bl = it.hasNext();
            return bl;
        }
        finally {
            it.close();
        }
    }

    @Override
    public void close() {
        this.m_reif.close();
    }

    @Override
    public void clear() {
        this.m_reif.removeStatementsFromDB(this.my_GID);
    }

    static boolean isReifProp(Node_URI p) {
        return p.equals(RDF.Nodes.subject) || p.equals(RDF.Nodes.predicate) || p.equals(RDF.Nodes.object) || p.equals(RDF.Nodes.type);
    }

    @Override
    public int getGraphId() {
        return ((DBIDInt)this.my_GID).getIntID();
    }

    @Override
    public IPSet getPSet() {
        return this.m_pset;
    }

    @Override
    public DBPropLSet getDBPropLSet() {
        return this.m_dbPropLSet;
    }

    @Override
    public char subsumes(Triple pattern, int reifBehavior) {
        int res = 110;
        if (reifBehavior != 1) {
            return (char)res;
        }
        Node pred = pattern.getPredicate();
        if (pred.isConcrete()) {
            if (pred.equals(RDF.Nodes.subject) || pred.equals(RDF.Nodes.predicate) || pred.equals(RDF.Nodes.object)) {
                res = 97;
            } else if (pred.equals(RDF.Nodes.type)) {
                Node obj = pattern.getObject();
                if (obj.equals(RDF.Nodes.Statement)) {
                    res = 97;
                } else if (!obj.isConcrete()) {
                    res = 115;
                }
            }
        } else if (pred.isVariable() || pred.equals(Node.ANY)) {
            res = 115;
        } else {
            throw new JenaException("Unexpected predicate: " + pred.toString());
        }
        return (char)res;
    }
}

