/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules.helper;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.osivia.procedures.record.security.rules.helper.RecordHelper;
import org.osivia.procedures.record.security.rules.model.relation.RelationModel;
import org.osivia.procedures.record.security.rules.model.type.Entity;

public class RecordsFetcherHelper {
    public static final String RECORDS_QUERY = "select * from Record where rcd:type = '%s' and rcd:data.%s.ttc:webid in %s  and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ";
    public static final String TGT_RECORDS_QUERY = "select * from Record where rcd:type = '%s' and ttc:webid in %s  and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ";

    private RecordsFetcherHelper() {
    }

    public static DocumentModelList fetchSourceRecords(CoreSession session, RelationModel relationModel, Entity targetEntity) {
        List<String> tgtIds = RecordsFetcherHelper.getIds(targetEntity);
        String query = String.format(RECORDS_QUERY, relationModel.getSourceType(), relationModel.getTargetKey(), RecordsFetcherHelper.getInOperand(tgtIds));
        return ToutaticeEsQueryHelper.query((CoreSession)session, (String)query, (int)-1);
    }

    public static List<String> getIds(Entity entity) {
        ArrayList<String> ids = new ArrayList<String>(0);
        if (entity.getRecords() != null) {
            for (DocumentModel record : entity.getRecords()) {
                ids.add((String)record.getProperty("ttc:webid").getValue(String.class));
            }
        }
        return ids;
    }

    public static DocumentModelList fetchTargetRecords(CoreSession session, RelationModel relationModel, Entity srcEntity, Entity targetEntity) {
        List<String> ids = RecordsFetcherHelper.getTargetIds(session, srcEntity.getRecordModel().getDocument(), srcEntity, relationModel);
        String query = String.format(TGT_RECORDS_QUERY, targetEntity.getType(), RecordsFetcherHelper.getInOperand(ids));
        return ToutaticeEsQueryHelper.query((CoreSession)session, (String)query, (int)-1);
    }

    public static List<String> getTargetIds(CoreSession session, DocumentModel model, Entity entity, RelationModel relationModel) {
        List<String> webIds = null;
        String targetKey = relationModel.getTargetKey();
        if (StringUtils.isNotBlank((String)targetKey)) {
            String webIdsAsString = null;
            webIds = new ArrayList<String>(0);
            for (DocumentModel record : entity.getRecords()) {
                ListProperty fields = (ListProperty)record.getProperty("rcd:globalVariablesValues");
                for (Property field : fields) {
                    MapProperty fld = (MapProperty)field;
                    if (!StringUtils.equals((String)targetKey, (String)((String)fld.get("name").getValue(String.class)))) continue;
                    webIdsAsString = (String)fld.get("value").getValue(String.class);
                }
                if (!StringUtils.isNotBlank(webIdsAsString)) continue;
                webIds = RecordHelper.getIds(webIds, webIdsAsString);
            }
        }
        return webIds;
    }

    public static String getInOperand(List<String> elements) {
        StringBuffer operand = new StringBuffer();
        if (elements != null) {
            operand.append("('");
            operand.append(StringUtils.join(elements, (String)"','"));
            operand.append("')");
        }
        return operand.toString();
    }
}

