/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaChangeHandler;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaObjectRegistry;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;

public class MetaSchemaHandler
implements SchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final PartitionSchemaLoader loader;
    private final Registries globalRegistries;
    private final AttributeType disabledAT;
    private final String OU_OID;
    private final AttributeType cnAT;
    private final AttributeType dependenciesAT;

    public MetaSchemaHandler(Registries globalRegistries, PartitionSchemaLoader loader) throws NamingException {
        this.globalRegistries = globalRegistries;
        this.disabledAT = globalRegistries.getAttributeTypeRegistry().lookup("m-disabled");
        this.loader = loader;
        this.OU_OID = globalRegistries.getOidRegistry().getOid("ou");
        this.factory = new SchemaEntityFactory(globalRegistries);
        this.cnAT = globalRegistries.getAttributeTypeRegistry().lookup("cn");
        this.dependenciesAT = globalRegistries.getAttributeTypeRegistry().lookup("m-dependencies");
    }

    public void modify(LdapDN name, int modOp, Attributes mods, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        Attribute disabledInMods = AttributeUtils.getAttribute((Attributes)mods, (AttributeType)this.disabledAT);
        if (disabledInMods != null) {
            this.disable(name, modOp, disabledInMods, AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.disabledAT));
        }
        boolean isEnabled = false;
        Attribute disabled = AttributeUtils.getAttribute((Attributes)targetEntry, (AttributeType)this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.get().equals("TRUE")) {
            isEnabled = true;
        }
        Attribute dependencies = AttributeUtils.getAttribute((Attributes)mods, (AttributeType)this.dependenciesAT);
        if (dependencies != null) {
            this.checkForDependencies(isEnabled, targetEntry);
        }
    }

    public void modify(LdapDN name, ModificationItemImpl[] mods, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        Attribute disabledInEntry = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.disabledAT);
        ModificationItemImpl disabledModification = AttributeUtils.getModificationItem((ModificationItemImpl[])mods, (AttributeType)this.disabledAT);
        if (disabledModification != null) {
            this.disable(name, disabledModification.getModificationOp(), disabledModification.getAttribute(), disabledInEntry);
        }
        boolean isEnabled = false;
        Attribute disabled = AttributeUtils.getAttribute((Attributes)targetEntry, (AttributeType)this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.get().equals("TRUE")) {
            isEnabled = true;
        }
        Attribute dependencies = AttributeUtils.getAttribute((ModificationItemImpl[])mods, (AttributeType)this.dependenciesAT);
        if (dependencies != null) {
            this.checkForDependencies(isEnabled, targetEntry);
        }
    }

    public void add(LdapDN name, Attributes entry) throws NamingException {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        parentDn.normalize(this.globalRegistries.getAttributeTypeRegistry().getNormalizerMapping());
        if (!parentDn.toNormName().equals(this.OU_OID + "=schema")) {
            throw new LdapInvalidNameException("The parent dn of a schema should be " + this.OU_OID + "=schema and not: " + parentDn.toNormName(), ResultCodeEnum.NAMING_VIOLATION);
        }
        boolean isEnabled = false;
        Attribute disabled = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.get().equals("TRUE")) {
            isEnabled = true;
        }
        this.checkForDependencies(isEnabled, entry);
        if (isEnabled) {
            Schema schema = this.factory.getSchema(entry);
            this.globalRegistries.addToLoadedSet(schema);
        }
    }

    public void delete(LdapDN name, Attributes entry, boolean cascade) throws NamingException {
        Attribute cn = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.cnAT);
        String schemaName = (String)cn.get();
        Set<String> dependents = this.loader.listDependentSchemaNames(schemaName);
        if (!dependents.isEmpty()) {
            throw new LdapOperationNotSupportedException("Cannot delete schema that has dependents: " + dependents, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        this.globalRegistries.removeFromLoadedSet(schemaName);
    }

    public void rename(LdapDN name, Attributes entry, String newRdn, boolean cascade) throws NamingException {
        String rdnAttribute = NamespaceTools.getRdnAttribute((String)newRdn);
        String rdnAttributeOid = this.globalRegistries.getOidRegistry().getOid(rdnAttribute);
        if (!rdnAttributeOid.equals(this.cnAT.getOid())) {
            throw new LdapOperationNotSupportedException("Cannot allow rename with rdnAttribute set to " + rdnAttribute + ": cn must be used instead.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String schemaName = this.getSchemaName(name);
        Set<String> dependents = this.loader.listDependentSchemaNames(schemaName);
        if (!dependents.isEmpty()) {
            throw new LdapOperationNotSupportedException("Cannot allow a rename on " + schemaName + " schema while it has depentents.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        boolean isEnabled = false;
        Attribute disabled = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.get().equals("TRUE")) {
            isEnabled = true;
        }
        if (!isEnabled) {
            return;
        }
        String newSchemaName = NamespaceTools.getRdnValue((String)newRdn);
        this.globalRegistries.getComparatorRegistry().renameSchema(schemaName, newSchemaName);
        this.globalRegistries.getNormalizerRegistry().renameSchema(schemaName, newSchemaName);
        this.globalRegistries.getSyntaxCheckerRegistry().renameSchema(schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getAttributeTypeRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getDitContentRuleRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getDitStructureRuleRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getMatchingRuleRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getMatchingRuleUseRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getNameFormRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getObjectClassRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getSyntaxRegistry(), schemaName, newSchemaName);
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn, Attributes entry, boolean cascade) throws NamingException {
        throw new LdapOperationNotSupportedException("Moving around schemas is not allowed.", ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, Attributes entry, boolean cascade) throws NamingException {
        throw new LdapOperationNotSupportedException("Moving around schemas is not allowed.", ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    private void disable(LdapDN name, int modOp, Attribute disabledInMods, Attribute disabledInEntry) throws NamingException {
        switch (modOp) {
            case 1: {
                if (disabledInEntry != null || !"TRUE".equalsIgnoreCase((String)disabledInMods.get())) break;
                this.disableSchema(this.getSchemaName(name));
                break;
            }
            case 3: {
                if (!"TRUE".equalsIgnoreCase((String)disabledInEntry.get())) break;
                this.enableSchema(this.getSchemaName(name));
                break;
            }
            case 2: {
                boolean isCurrentlyDisabled = "TRUE".equalsIgnoreCase((String)disabledInEntry.get());
                boolean isNewStateDisabled = "TRUE".equalsIgnoreCase((String)disabledInMods.get());
                if (isCurrentlyDisabled && !isNewStateDisabled) {
                    this.enableSchema(this.getSchemaName(name));
                    break;
                }
                if (isCurrentlyDisabled || !isNewStateDisabled) break;
                this.disableSchema(this.getSchemaName(name));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown modify operation type: " + modOp);
            }
        }
    }

    private final String getSchemaName(LdapDN schema) throws NamingException {
        return (String)schema.getRdn().getValue();
    }

    private void disableSchema(String schemaName) throws NamingException {
        Set<String> dependents = this.loader.listEnabledDependentSchemaNames(schemaName);
        if (!dependents.isEmpty()) {
            throw new LdapOperationNotSupportedException("Cannot disable schema with enabled dependents: " + dependents, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        this.globalRegistries.unload(schemaName);
    }

    private void enableSchema(String schemaName) throws NamingException {
        if (this.globalRegistries.getLoadedSchemas().containsKey(schemaName)) {
            return;
        }
        Schema schema = this.loader.getSchema(schemaName);
        this.loader.loadWithDependencies(schema, this.globalRegistries);
    }

    private void checkForDependencies(boolean isEnabled, Attributes entry) throws NamingException {
        Attribute dependencies = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.dependenciesAT);
        if (dependencies == null) {
            return;
        }
        if (isEnabled) {
            Map loaded = this.globalRegistries.getLoadedSchemas();
            for (int ii = 0; ii < dependencies.size(); ++ii) {
                String dependency = (String)dependencies.get(ii);
                if (loaded.containsKey(dependency)) continue;
                throw new LdapOperationNotSupportedException("Unwilling to perform operation on enabled schema with disabled or missing dependencies: " + dependency, ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
        } else {
            Set<String> allSchemas = this.loader.getSchemaNames();
            for (int ii = 0; ii < dependencies.size(); ++ii) {
                String dependency = (String)dependencies.get(ii);
                if (allSchemas.contains(dependency)) continue;
                throw new LdapOperationNotSupportedException("Unwilling to perform operation on schema with missing dependencies: " + dependency, ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
        }
    }

    private void renameSchema(SchemaObjectRegistry registry, String originalSchemaName, String newSchemaName) {
        for (SchemaObject obj : registry) {
            if (!obj.getSchema().equalsIgnoreCase(originalSchemaName)) continue;
            obj.setSchema(newSchemaName);
        }
    }
}

