/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.mee.ecm.automation;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.seam.annotations.In;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.GetOutgoingRelations", category="Document", label="Get outgoing relations", description="Get outgoing relations")
public class GetOutgoingRelations {
    public static final String ID = "Document.GetOutgoingRelations";
    @In(create=true)
    protected RelationManager relationManager;
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentModelList run(DocumentModel input) throws Exception {
        DocumentModel docSrc;
        DocumentModelListImpl docModelLst = new DocumentModelListImpl();
        if (this.relationManager == null) {
            this.relationManager = (RelationManager)Framework.getService(RelationManager.class);
        }
        if ((docSrc = this.session.getSourceDocument(input.getRef())).isProxy() || docSrc.isVersion()) {
            for (int i = 0; i < 5 && (docSrc.isProxy() || docSrc.isVersion()); ++i) {
                docSrc = this.session.getSourceDocument(docSrc.getRef());
            }
        }
        Resource docResource = this.relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)docSrc, null);
        Graph graph = this.relationManager.getGraphByName("default");
        List outgoingStatements = graph.getStatements((Node)docResource, null, null);
        for (Statement statement : outgoingStatements) {
            Node object = statement.getObject();
            DocumentModel doc = this.getDocumentModel(object);
            if (doc == null) continue;
            docModelLst.add((Object)doc);
        }
        return docModelLst;
    }

    private DocumentModel getDocumentModel(Node node) throws ClientException {
        DocumentModel res = null;
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            Map<String, CoreSession> context = Collections.singletonMap("CoreSession", this.session);
            Serializable o = this.relationManager.getResourceRepresentation(resource.getNamespace(), (Resource)resource, context);
            if (o instanceof DocumentModel) {
                res = (DocumentModel)o;
            }
        }
        return res;
    }
}

