/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.inheritance;

import fr.toutatice.ecm.platform.service.inheritance.ToutaticeInheritanceSetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.EventContext;

public class AcrennesInheritanceKeyWordsModifySetter
implements ToutaticeInheritanceSetter {
    private static final Log log = LogFactory.getLog(AcrennesInheritanceKeyWordsModifySetter.class);
    static final String XPATH = "dc:subjects";

    public boolean execute(EventContext context, DocumentModel source, DocumentModel destination) {
        boolean updated = false;
        Integer recursionCount = (Integer)context.getProperty("recursionDepthCount");
        if (null != source && null != destination && !destination.isFolder() && 1 == recursionCount) {
            try {
                Property srcProperty = source.getProperty(XPATH);
                if (null != srcProperty) {
                    Property dstProperty = destination.getProperty(XPATH);
                    String[] srcValues = (String[])srcProperty.getValue();
                    String[] dstValues = (String[])dstProperty.getValue();
                    ArrayList<String> newValues = new ArrayList<String>();
                    newValues.addAll(Arrays.asList(dstValues));
                    for (String srcValue : srcValues) {
                        if (newValues.contains(srcValue)) continue;
                        newValues.add(srcValue);
                    }
                    destination.setPropertyValue(XPATH, (Serializable)newValues.toArray(new String[newValues.size()]));
                    updated = true;
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to set the key words property, error: " + e.getMessage()));
            }
        }
        return updated;
    }
}

