/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class AcrennesUserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final Log uwLog = LogFactory.getLog((String)"fr.toutatice.userworkspaces");
    private static final long serialVersionUID = 1L;
    protected static final String OLD_DOMAIN_NAME = "userworkspace-domain";
    protected static final String OLD_USERWORKSPACES_ROOT = "userworkspaces";
    protected static final int UW_PREFIX_SEGMENT_SIZE = 3;
    private List<String> deniedProfiles;

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String usedUsername, DocumentModel currentDocument) throws ClientException {
        return StringUtils.substringBeforeLast((String)super.computePathUserWorkspaceRoot(userCoreSession, usedUsername, currentDocument), (String)"/UserWorkspaces");
    }

    protected PathRef resolveUserWorkspace(CoreSession session, PathRef homeDomainRef, String username, String workspacename, int maxsize) {
        PathRef usWsRef = null;
        String usWsName = super.getUserWorkspaceNameForUser(username);
        String usWsRootPath = this.computeOldPathUserWorkspaceRoot();
        Path usWsPath = this.computeUserWorspacePath(usWsRootPath, usWsName);
        usWsRef = new PathRef(usWsPath.toString());
        if (!session.exists((DocumentRef)usWsRef)) {
            usWsPath = this.computeUserWorspacePath(homeDomainRef.toString(), usWsName);
            usWsRef = new PathRef(usWsPath.toString());
        }
        return usWsRef;
    }

    protected String computeOldPathUserWorkspaceRoot() throws ClientException {
        return new Path("/userworkspace-domain").append(OLD_USERWORKSPACES_ROOT).toString();
    }

    protected Path computeUserWorspacePath(String rootPath, String usWsName) {
        Path usWsPath = new Path("/" + rootPath);
        for (int i = 0; i < usWsName.length() && i < 3; ++i) {
            usWsPath = usWsPath.append(usWsName.charAt(i) + "/");
        }
        usWsPath = usWsPath.append(usWsName);
        return usWsPath;
    }

    protected DocumentModel doCreateUserWorkspacesRoot(CoreSession unrestrictedSession, PathRef rootRef) throws ClientException {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, this.targetDomainName, this.getUserWorkspaceRootType());
        doc.setProperty("dublincore", "title", (Object)this.targetDomainName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        this.setUserWorkspaceRootACL(doc);
        return doc;
    }

    protected DocumentModel doCreateUserWorkspace(CoreSession unrestrictedSession, PathRef userWSRef, Principal principal, String userName) throws ClientException {
        DocumentModel uw = null;
        Path uwsPath = new Path(userWSRef.toString());
        for (int i = 2; i < uwsPath.segmentCount(); ++i) {
            PathRef nodeRef;
            if (uwLog.isDebugEnabled()) {
                uwLog.debug((Object)("    - Cr\u00e9ation du document " + uwsPath.uptoSegment(i).toString()));
            }
            if (unrestrictedSession.exists((DocumentRef)(nodeRef = new PathRef(uwsPath.uptoSegment(i).toString())))) continue;
            DocumentModel node = this.createUserWorkspacesRootSegment(unrestrictedSession, nodeRef);
            Validate.isTrue((boolean)node.getPathAsString().equals(nodeRef.toString()));
        }
        if (!unrestrictedSession.exists((DocumentRef)userWSRef) && this.userMayHaveWorkspace(userName)) {
            uwLog.info((Object)("Cr\u00e9ation du userWorkspace de [" + userName + "] : " + userWSRef.value));
            uw = this.createUserWorkspace(unrestrictedSession, userWSRef, userName);
            Validate.isTrue((boolean)uw.getPathAsString().equals(userWSRef.toString()));
        } else {
            uwLog.info((Object)("Pas de cr\u00e9ation de userWorkspace pour [" + userName + "], profil filtr\u00e9 !"));
        }
        if (uw != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("username", userName);
            this.notifyEvent(unrestrictedSession, uw, (NuxeoPrincipal)unrestrictedSession.getPrincipal(), "userWorkspaceCreated", properties);
        }
        return uw;
    }

    private boolean userMayHaveWorkspace(String userName) {
        boolean creationEnabled = BooleanUtils.toBoolean((String)Framework.getProperty((String)"fr.toutatice.userworkspaces.creationenabled", (String)"false"));
        if (!creationEnabled) {
            return false;
        }
        List<String> deniedProfiles = this.getDeniedProfiles();
        if (deniedProfiles.size() == 0) {
            return true;
        }
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        LDAPDirectory userDir = (LDAPDirectory)directoryService.getDirectory("userLdapDirectory");
        LDAPSession session = (LDAPSession)userDir.getSession();
        DirContext context = session.getContext();
        String searchBaseDn = userDir.getConfig().getSearchBaseDn();
        try {
            NamingEnumeration<SearchResult> search = context.search(searchBaseDn, "(uid=" + userName + ")", userDir.getSearchControls());
            SearchResult next = search.next();
            Attribute profilesAttr = next.getAttributes().get("entpersonprofils");
            for (int i = 0; i < profilesAttr.size(); ++i) {
                String memberOf = profilesAttr.get(i).toString();
                if (!deniedProfiles.contains(memberOf)) continue;
                return false;
            }
        }
        catch (NamingException e) {
            uwLog.error((Object)("Impossible de v\u00e9rifier les groupes de " + userName));
        }
        return true;
    }

    private List<String> getDeniedProfiles() {
        if (this.deniedProfiles == null) {
            this.deniedProfiles = new ArrayList<String>();
            String deniedProfilesProp = Framework.getProperty((String)"fr.toutatice.userworkspaces.denied_profiles");
            if (StringUtils.isNotBlank((String)deniedProfilesProp)) {
                String[] split;
                for (String spl : split = deniedProfilesProp.split(";")) {
                    this.deniedProfiles.add(spl.trim());
                    uwLog.info((Object)("Filtrage actif pour le profil " + spl));
                }
            }
        }
        return this.deniedProfiles;
    }

    protected DocumentModel createUserWorkspacesRootSegment(CoreSession unrestrictedSession, PathRef rootRef) throws ClientException {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        String docName = new Path(rootRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, docName, "UserWorkspacesRoot");
        doc.setProperty("dublincore", "title", (Object)docName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        super.setUserWorkspaceRootACL(doc);
        return doc;
    }

    protected DocumentModel createUserWorkspace(CoreSession unrestrictedSession, PathRef wsRef, String userName) throws ClientException {
        String parentPath = new Path(wsRef.toString()).removeLastSegments(1).toString();
        String wsName = new Path(wsRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, wsName, super.getUserWorkspaceType());
        doc.setProperty("dublincore", "title", (Object)userName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        super.setUserWorkspaceACL(doc, userName);
        return doc;
    }
}

