/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.AbstractActionContext;
import org.nuxeo.ecm.platform.actions.ActionContext;

public class ELActionContext
extends AbstractActionContext
implements ActionContext {
    private static final long serialVersionUID = 1L;
    protected final ELContext originalContext;
    protected final ExpressionFactory expressionFactory;

    public ELActionContext(ELContext originalContext, ExpressionFactory expressionFactory) {
        this.originalContext = originalContext;
        this.expressionFactory = expressionFactory;
    }

    @Override
    public boolean checkCondition(String expression) throws ELException {
        if (StringUtils.isBlank((String)expression) || expression != null && StringUtils.isBlank((String)expression.trim())) {
            return false;
        }
        String expr = expression.trim();
        if (!(expr.startsWith("#{") || expr.startsWith("${") || expr.endsWith("}"))) {
            expr = "#{" + expr + "}";
        }
        VariableMapper vm = this.originalContext.getVariableMapper();
        ValueExpression documentExpr = this.expressionFactory.createValueExpression((Object)this.getCurrentDocument(), DocumentModel.class);
        ValueExpression userExpr = this.expressionFactory.createValueExpression((Object)this.getCurrentPrincipal(), NuxeoPrincipal.class);
        vm.setVariable("document", documentExpr);
        vm.setVariable("principal", userExpr);
        vm.setVariable("currentDocument", documentExpr);
        vm.setVariable("currentUser", userExpr);
        for (String key : this.localVariables.keySet()) {
            vm.setVariable(key, this.expressionFactory.createValueExpression(this.getLocalVariable(key), Object.class));
        }
        ValueExpression ve = this.expressionFactory.createValueExpression(this.originalContext, expr, Boolean.class);
        return Boolean.TRUE.equals(ve.getValue(this.originalContext));
    }
}

