var lang = 'fr';

	function desactivateMediaButton(editor, selectedElm){
		if(selectedElm){
			var tagName = selectedElm.tagName;
			if('IMG' === tagName.toUpperCase()){ 
				var clazz = selectedElm.className;

					if(clazz.includes('mce-object-iframe')){
						var src = selectedElm.getAttribute('data-mce-p-src');
					} 
					if(clazz.includes('mce-object-object')){
						var src = selectedElm.getAttribute('data-mce-html');
					}

					if(src && src.includes('youtube')){
						editor.controlManager.setActive('media', false);
					}
			}
		}
}

function setTooltipButtons(editor) {
	var originalAddButton = editor.addButton;
	editor.addButton = function(name, settings) {
		if (!settings.tooltip && settings.title) {
			settings.tooltip = settings.title.substring(editor.settings.language.length + 1);
		}
		return originalAddButton.call(this, name, settings); 
	}

}

function createTinyMceBar(clazz) {
	var textareas = document.getElementsByClassName(clazz);
	for ( var index = 0; index < textareas.length; index++) {
		tinyMCE.execCommand('mceAddEditor', false, textareas[index].id);   
	}
}

function createTinyMCECustom() {

var tinymce = tinyMCE
      .init({
		height: "350px",
        width : "100%",
		mode : "specific_textareas",
		language : lang,
		theme : "modern",
		/* table_class_list integrated in plugins/table/plugin.js */
	    content_css: "/nuxeo/tinymce/themes/acrennes_content.css?" + new Date().getTime(),
	    tools: "inserttable",
		block_formats: "Paragraphe=p;Adresse=address;Préformaté=pre;Titre 1=h1;Titre 2=h2;Titre 3=h3;Titre 4=h4;Titre 5=h5;Titre 6=h6",
		editor_selector : "mceCustomEditor",
		editor_deselector : "disableMCEInit",
        plugins : ["compat3x fullscreen preview print paste searchreplace code insertdatetime textcolor table charmap emoticons link anchor ottc_image image imgmap nuxeoimageupload nuxeolink youtube media hr"],
        extended_valid_elements : "iframe[src|width|height|name|align|frameborder|allowfullscreen]",
        language : lang,

        relative_urls : false,
		remove_script_host: true,
		document_base_url : baseURL,

        toolbar1 : "fullscreen preview print | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | formatselect | fontselect | fontsizeselect",
        toolbar2 : "cut copy paste pastetext | searchreplace | bullist numlist | outdent indent blockquote | undo redo | code | insertdatetime | forecolor backcolor | hr removeformat | subscript superscript",
        toolbar3 : "table | charmap emoticons | nuxeolink link unlink anchor | nuxeoimageupload ottc_image | youtube media imgmap",
        menubar: false,

		setup : function(ed) {
      		ed.on('click', function (e) {
				desactivateMediaButton(ed, e.target);
			});
			setTooltipButtons(ed);
		}
      });
        
createTinyMceBar("mceCustomEditor,disableMCEInit");


}

window.addEventListener("load", createTinyMCECustom);
