/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

public enum FileBrowserView {
    LINES("lines", "glyphicons glyphicons-show-thumbnails-with-lines", true, false),
    THUMBNAILS("thumbnails", "glyphicons glyphicons-show-thumbnails", false, true);

    public static final FileBrowserView DEFAULT;
    private final String name;
    private final String icon;
    private final boolean orderable;
    private final boolean closedNavigation;

    private FileBrowserView(String name, String icon, boolean orderable, boolean closedNavigation) {
        this.name = name;
        this.icon = icon;
        this.orderable = orderable;
        this.closedNavigation = closedNavigation;
    }

    public static final FileBrowserView fromName(String name) {
        FileBrowserView result = DEFAULT;
        if (name != null) {
            for (FileBrowserView view : FileBrowserView.values()) {
                if (!name.equals(view.name)) continue;
                result = view;
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public boolean isClosedNavigation() {
        return this.closedNavigation;
    }

    static {
        DEFAULT = LINES;
    }
}

