/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services.dao;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.liveedit.OnlyofficeLiveEditHelper;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.IDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.locator.Locator;

public final class DocumentDAO
implements IDAO<Document, DocumentDTO> {
    private static final String NUXEO_DATE_REGEX = "[\\-0-9]+T[:\\.0-9]+Z";
    private static DocumentDAO instance;
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private final Pattern datePattern = Pattern.compile("[\\-0-9]+T[:\\.0-9]+Z");

    private DocumentDAO() {
    }

    public static DocumentDAO getInstance() {
        if (instance == null) {
            instance = new DocumentDAO();
        }
        return instance;
    }

    @Override
    public DocumentDTO toDTO(Document document) {
        DocumentType spaceType;
        DocumentDTO dto = new DocumentDTO();
        dto.setId(document.getId());
        dto.setTitle(document.getTitle());
        dto.setPath(document.getPath());
        DocumentType type = this.getType(document.getType());
        dto.setType(type);
        if (type != null) {
            String icon = type.isFile() ? StringUtils.defaultIfEmpty((String)this.getIcon(document), (String)type.getGlyph()) : type.getGlyph();
            dto.setIcon(icon);
        }
        dto.setLiveEditable(this.isLiveEditable(document));
        Map<String, Object> properties = dto.getProperties();
        properties.putAll(this.toMap(document.getProperties()));
        dto.setDocument(document);
        String spaceTypeStr = document.getProperties().getString("ttc:spaceType");
        if (spaceTypeStr != null && (spaceType = this.getType(spaceTypeStr)) != null) {
            String icon = spaceType.getGlyph();
            dto.setSpaceIcon(icon);
        }
        return dto;
    }

    private List<Object> toList(PropertyList propertyList) {
        ArrayList<Object> list = new ArrayList<Object>(propertyList.size());
        int index = 0;
        for (Object object : propertyList.list()) {
            if (object instanceof PropertyMap) {
                PropertyMap propertyMapValue = (PropertyMap)object;
                list.add(this.toMap(propertyMapValue));
            } else if (object instanceof PropertyList) {
                PropertyList propertyListValue = (PropertyList)object;
                list.add(this.toList(propertyListValue));
            } else if (object instanceof String) {
                String stringValue = (String)object;
                Matcher dateMatcher = this.datePattern.matcher(stringValue);
                if (dateMatcher.matches()) {
                    Date date = propertyList.getDate(index);
                    list.add(date);
                } else {
                    list.add(stringValue);
                }
            } else {
                list.add(object);
            }
            ++index;
        }
        return list;
    }

    private Map<String, Object> toMap(PropertyMap propertyMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(propertyMap.size());
        for (Map.Entry entry : propertyMap.map().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof PropertyMap) {
                PropertyMap propertyMapValue = (PropertyMap)value;
                map.put(key, this.toMap(propertyMapValue));
                continue;
            }
            if (value instanceof PropertyList) {
                PropertyList propertyListValue = (PropertyList)value;
                map.put(key, this.toList(propertyListValue));
                continue;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                Matcher dateMatcher = this.datePattern.matcher(stringValue);
                if (dateMatcher.matches()) {
                    Date date = propertyMap.getDate(key);
                    map.put(key, date);
                    continue;
                }
                map.put(key, stringValue);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private DocumentType getType(String type) {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        Map<String, DocumentType> types = cmsCustomizer.getCMSItemTypes();
        return types.get(type);
    }

    private boolean isLiveEditable(Document document) {
        boolean isPluginRegistered;
        String mimeType;
        PropertyMap properties = document.getProperties();
        PropertyMap fileContent = properties.getMap("file:content");
        if (fileContent != null && StringUtils.isNotBlank((String)(mimeType = fileContent.getString("mime-type"))) && (isPluginRegistered = this.nuxeoService.getCMSCustomizer().getCustomizationService().isPluginRegistered("onlyoffice.plugin"))) {
            return OnlyofficeLiveEditHelper.isMimeTypeSupported(mimeType);
        }
        return false;
    }

    private String getIcon(Document document) {
        String icon;
        PropertyMap properties = document.getProperties();
        PropertyMap fileContent = properties.getMap("file:content");
        if (fileContent == null) {
            icon = null;
        } else {
            String mimeType = fileContent.getString("mime-type");
            icon = this.getIcon(mimeType);
        }
        return icon;
    }

    public String getIcon(String mimeType) {
        String icon;
        MimeType mimeTypeObject;
        try {
            mimeTypeObject = new MimeType(mimeType);
        }
        catch (Exception e) {
            mimeTypeObject = null;
        }
        boolean flaticon = false;
        if (mimeTypeObject == null) {
            icon = null;
        } else {
            String primaryType = mimeTypeObject.getPrimaryType();
            String subType = mimeTypeObject.getSubType();
            if ("application".equals(primaryType)) {
                if ("pdf".equals(subType)) {
                    icon = "pdf";
                    flaticon = true;
                } else if ("msword".equals(subType) || "vnd.openxmlformats-officedocument.wordprocessingml.document".equals(subType)) {
                    icon = "word";
                    flaticon = true;
                } else if ("vnd.ms-excel".equals(subType) || "vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(subType) || "vnd.ms-excel.sheet.macroenabled.12".equals(subType)) {
                    icon = "excel";
                    flaticon = true;
                } else if ("vnd.ms-powerpoint".equals(subType) || "vnd.openxmlformats-officedocument.presentationml.presentation".equals(subType)) {
                    icon = "powerpoint";
                    flaticon = true;
                } else if ("vnd.oasis.opendocument.text".equals(subType)) {
                    icon = "odt";
                    flaticon = true;
                } else if ("vnd.oasis.opendocument.spreadsheet".equals(subType)) {
                    icon = "ods";
                    flaticon = true;
                } else if ("vnd.oasis.opendocument.presentation".equals(subType)) {
                    icon = "odp";
                    flaticon = true;
                } else if ("zip".equals(subType) || "gzip".equals(subType)) {
                    icon = "archive";
                    flaticon = true;
                } else {
                    icon = null;
                }
            } else if ("text".equals(primaryType)) {
                if ("html".equals(subType) || "xml".equals(subType)) {
                    icon = "xml";
                    flaticon = true;
                } else {
                    icon = "text";
                    flaticon = true;
                }
            } else {
                icon = "image".equals(primaryType) ? "picture" : ("video".equals(primaryType) ? "film" : ("audio".equals(primaryType) ? "music" : null));
            }
        }
        if (icon != null) {
            icon = flaticon ? "flaticon flaticon-" + icon : "glyphicons glyphicons-" + icon;
        }
        return icon;
    }
}

