/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services.dao;

import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.IDAO;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;

public final class CommentDAO
implements IDAO<JSONObject, CommentDTO> {
    private static CommentDAO instance;
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);

    private CommentDAO() {
    }

    public static CommentDAO getInstance() {
        if (instance == null) {
            instance = new CommentDAO();
        }
        return instance;
    }

    @Override
    public CommentDTO toDTO(JSONObject jsonObject) {
        return this.toDTO((PortalControllerContext)null, jsonObject);
    }

    @Override
    public CommentDTO toDTO(PortalControllerContext portalControllerContext, JSONObject jsonObject) {
        CommentDTO dto = new CommentDTO();
        dto.setId(jsonObject.getString("id"));
        dto.setPath(jsonObject.getString("path"));
        String author = jsonObject.getString("author");
        dto.setAuthor(author);
        Person person = this.personService.getPerson(author);
        dto.setPerson(person);
        JSONObject jsonDate = jsonObject.getJSONObject("creationDate");
        dto.setCreationDate(new Date(jsonDate.getLong("timeInMillis")));
        String content = jsonObject.getString("content");
        dto.setContent(content);
        dto.setDeletable(jsonObject.getBoolean("canDelete"));
        JSONArray jsonChildren = jsonObject.getJSONArray("children");
        for (int i = 0; i < jsonChildren.size(); ++i) {
            JSONObject jsonChild = jsonChildren.getJSONObject(i);
            CommentDTO childDTO = this.toDTO(jsonChild);
            dto.getChildren().add(childDTO);
        }
        return dto;
    }
}

