/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.discussions;

import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class DiscussionHelper {
    public static String ATTR_LOCAL_PUBLICATION_CACHE = "osivia.cms.discussions.publication.infos";
    private static IPortalUrlFactory portalUrlFactory;
    private static IBundleFactory bundleFactory;

    private static IPortalUrlFactory getUrlFactory() {
        if (portalUrlFactory == null) {
            portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        }
        return portalUrlFactory;
    }

    public static String getDiscussionUrl(PortalControllerContext portalControllerContext, String id, String participant, String publicationId) {
        String url;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.hideTitle", "1");
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("view", "detail");
        if (id != null) {
            params.put("id", id);
        }
        if (participant != null) {
            params.put("participant", participant);
        }
        if (publicationId != null) {
            params.put("publicationId", publicationId);
        }
        params.put("anchor", "newMessage");
        try {
            url = DiscussionHelper.getUrlFactory().getStartPortletInNewPage(portalControllerContext, "discussion", "Discussion", "index-cloud-ens-discussion-instance", properties, params);
        }
        catch (PortalException e) {
            url = "#";
        }
        return url;
    }

    public static String getDiscussionUrlByParticipant(PortalControllerContext portalControllerContext, String participant) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, null, participant, null);
    }

    public static String getDiscussionUrlByPublication(PortalControllerContext portalControllerContext, String publicationId) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, null, null, publicationId);
    }

    public static String getDiscussionUrlById(PortalControllerContext portalControllerContext, String id) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, id, null, null);
    }

    public static void resetLocalPublications(PortalControllerContext portalControllerContext) {
        HttpSession session = portalControllerContext.getHttpServletRequest().getSession();
        session.removeAttribute(ATTR_LOCAL_PUBLICATION_CACHE);
    }
}

