/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cms.CMSContext;
import org.osivia.portal.api.cms.CMSController;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.UpdateInformations;
import org.osivia.portal.api.cms.UpdateScope;
import org.osivia.portal.api.cms.model.Document;
import org.osivia.portal.api.cms.service.CMSService;
import org.osivia.portal.api.cms.service.CMSSession;
import org.osivia.portal.api.cms.service.Request;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.cms.Satellite;
import org.osivia.portal.core.cms.spi.NuxeoRepository;
import org.osivia.portal.core.cms.spi.NuxeoRequest;
import org.osivia.portal.core.cms.spi.NuxeoResult;
import org.osivia.portal.core.formatters.IFormatter;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.profils.IProfilManager;
import org.osivia.portal.core.profils.ProfilBean;
import org.osivia.portal.core.web.IWebIdService;

public class NuxeoController {
    public static final String NUXEO_REPOSITORY_NAME = "nx";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String FETCH_PATH_PREFIX = "webId:";
    private static final String CMS_PATH_PREFIX = "/_id";
    private static ICMSServiceLocator cmsServiceLocator;
    private final ITaskbarService taskbarService;
    public boolean asynchronousUpdates = false;
    PortletRequest request;
    PortletResponse response;
    PortletContext portletCtx;
    IPortalUrlFactory urlFactory;
    INuxeoService nuxeoCMSService;
    String pageId;
    URI nuxeoBaseURI;
    NuxeoConnectionProperties nuxeoConnection;
    IFormatter formatter;
    IProfilManager profilManager;
    String scope;
    String displayLiveVersion;
    String basePath;
    String navigationPath;
    String itemNavigationPath;
    String docTypeToCreate;
    String parentPathToCreate;
    String domainPath;
    HttpServletRequest servletRequest;
    String contentPath;
    String spacePath;
    String forcePublicationInfosScope;
    String menuRootPath;
    String hideMetaDatas;
    String displayContext;
    String navigationScope = null;
    CMSItem navItem;
    CMSServiceCtx cmsCtx;
    boolean reloadResource = false;
    boolean streamingSupport = false;
    String forcedLivePath = null;
    org.nuxeo.ecm.automation.client.model.Document currentDoc;
    PortalControllerContext portalCtx;
    IWebIdService webIdService;
    String pageMarker;
    int authType = NuxeoCommandContext.AUTH_TYPE_USER;
    int cacheType = CacheInfo.CACHE_SCOPE_NONE;
    boolean forceReload = false;
    INuxeoCommandService nuxeoCommandService;
    private static String cmsContextName;
    private IDirectoryServiceLocator directoryServiceLocator;
    private IDirectoryService directoryService;
    private Satellite satellite;
    private boolean asynchronousCommand;
    private ProfilBean scopeProfil = null;
    private long cacheTimeOut = -1L;

    public NuxeoController(PortletRequest request, PortletResponse response, PortletContext portletCtx) throws RuntimeException {
        this.request = request;
        this.response = response;
        this.portletCtx = portletCtx;
        try {
            Set satellites;
            String satelliteName;
            String notSupportedPath;
            String contentId;
            String navigationId;
            String[] parts;
            String displayLiveVersionAttr;
            String displayLiveVersionParam;
            String displayLiveVersion;
            String forcePublicationScope;
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            this.portalCtx = new PortalControllerContext(portletCtx, request, response);
            String scope = window.getProperty("osivia.cms.scope");
            if ("__inherited".equals(scope) && (scope = request.getParameter("osivia.cms.pageScope")) == null) {
                scope = window.getPageProperty("osivia.cms.scope");
            }
            if ((forcePublicationScope = window.getProperty("osivia.cms.forcePublicationScope")) != null) {
                if ("__inherited".equals(forcePublicationScope) && (forcePublicationScope = request.getParameter("osivia.cms.pageScope")) == null) {
                    forcePublicationScope = window.getPageProperty("osivia.cms.scope");
                }
                if (forcePublicationScope != null) {
                    scope = forcePublicationScope;
                    this.setForcePublicationInfosScope(forcePublicationScope);
                }
            }
            this.navigationScope = window.getPageProperty("osivia.cms.navigationScope");
            String spaceId = window.getPageProperty("osivia.spaceId");
            if (spaceId != null) {
                try {
                    UniversalID id = new UniversalID(spaceId);
                    if (id.getRepositoryName().equals(NUXEO_REPOSITORY_NAME)) {
                        NuxeoRepository repository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(this.getCMSContext(), id.getRepositoryName());
                        this.basePath = repository.getPath(id.getInternalID());
                        this.spacePath = repository.getPath(id.getInternalID());
                    }
                }
                catch (Exception e) {
                    throw this.wrapNuxeoException(e);
                }
            }
            CMSItem publishSpaceConfig = null;
            if (this.spacePath != null) {
                publishSpaceConfig = NuxeoController.getCMSService().getSpaceConfig(this.getCMSCtx(), this.spacePath);
            }
            if ("__inherited".equals(displayLiveVersion = window.getProperty("osivia.cms.displayLiveVersion"))) {
                displayLiveVersion = publishSpaceConfig != null ? (String)publishSpaceConfig.getProperties().get("displayLiveVersion") : window.getPageProperty("osivia.cms.displayLiveVersion");
            }
            if ((displayLiveVersionParam = request.getParameter("displayLiveVersion")) != null) {
                displayLiveVersion = displayLiveVersionParam;
            }
            if ((displayLiveVersionAttr = (String)request.getAttribute("osivia.cms.displayLiveVersion")) != null) {
                displayLiveVersion = displayLiveVersionAttr;
            }
            this.setScope(scope);
            this.setDisplayLiveVersion(displayLiveVersion);
            this.setHideMetaDatas(window.getProperty("osivia.cms.hideMetaDatas"));
            this.setDocTypeToCreate(window.getProperty("osivia.createDocType"));
            String parentPathToCreate = window.getProperty("osivia.createParentPath");
            this.setParentPathToCreate(parentPathToCreate);
            this.setPageMarker((String)request.getAttribute("osivia.pageMarker"));
            if (this.basePath != null && (parts = this.basePath.split(SLASH)) != null && parts.length > 0) {
                this.domainPath = SLASH + parts[1];
            }
            if ((navigationId = window.getPageProperty("osivia.navigationId")) != null) {
                try {
                    UniversalID id = new UniversalID(navigationId);
                    if (id.getRepositoryName().equals(NUXEO_REPOSITORY_NAME)) {
                        NuxeoRepository repository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(this.getCMSContext(), id.getRepositoryName());
                        this.itemNavigationPath = this.navigationPath = repository.getPath(id.getInternalID());
                    }
                }
                catch (Exception e) {
                    throw this.wrapNuxeoException(e);
                }
            }
            if ((contentId = window.getPageProperty("osivia.contentId")) != null) {
                try {
                    UniversalID id = new UniversalID(contentId);
                    if (id.getRepositoryName().equals(NUXEO_REPOSITORY_NAME)) {
                        NuxeoRepository repository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(this.getCMSContext(), id.getRepositoryName());
                        this.contentPath = repository.getPath(id.getInternalID());
                    }
                }
                catch (Exception e) {
                    throw this.wrapNuxeoException(e);
                }
            }
            if (this.contentPath == null && (notSupportedPath = window.getProperty("osivia.cms.notSupportedPath")) != null) {
                this.contentPath = notSupportedPath;
            }
            if (request instanceof ResourceRequest && request.getParameter("refresh") != null) {
                this.reloadResource = true;
            }
            if (this.getRequest() != null) {
                IContributionService.EditionState editionState = (IContributionService.EditionState)this.getRequest().getAttribute("osivia.editionState");
                if (editionState != null && IContributionService.EditionState.CONTRIBUTION_MODE_EDITION.equals(editionState.getContributionMode())) {
                    this.forcedLivePath = editionState.getDocPath();
                } else {
                    String webPageEditionPath = (String)this.getRequest().getAttribute("osivia.cms.webPageEditionPath");
                    if (webPageEditionPath != null) {
                        this.forcedLivePath = editionState.getDocPath();
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)(satelliteName = window.getProperty("osivia.satellite"))) && CollectionUtils.isNotEmpty((Collection)(satellites = NuxeoController.getCMSService().getSatellites()))) {
                Satellite satellite = null;
                Iterator iterator = satellites.iterator();
                while (satellite == null && iterator.hasNext()) {
                    Satellite next = (Satellite)iterator.next();
                    if (!StringUtils.equals((String)satelliteName, (String)next.getId())) continue;
                    satellite = next;
                }
                this.satellite = satellite;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
    }

    public NuxeoController(PortalControllerContext portalControllerContext) {
        this(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
    }

    public NuxeoController(PortletContext portletCtx) {
        this.portletCtx = portletCtx;
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
    }

    public static String getLivePath(String path) {
        return StringUtils.removeEnd((String)path, (String)".proxy");
    }

    public static ICMSService getCMSService() {
        if (cmsServiceLocator == null) {
            cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        }
        return cmsServiceLocator.getCMSService();
    }

    public static String webIdToFetchPath(String webId) {
        String fetchPath = webId != null ? FETCH_PATH_PREFIX.concat(webId) : null;
        return fetchPath;
    }

    public static String cmsPathToFetchPath(String cmsPath) {
        String webId = StringUtils.substringAfterLast((String)cmsPath, (String)SLASH);
        webId = StringUtils.substringBefore((String)webId, (String)DOT);
        return NuxeoController.webIdToFetchPath(webId);
    }

    public static String webIdToCmsPath(String webId) {
        StringBuilder path = new StringBuilder();
        path.append(CMS_PATH_PREFIX);
        path.append(SLASH);
        path.append(webId);
        return path.toString();
    }

    public void notifyUpdate(String documentPath, String spacePath, UpdateScope scope, boolean async) throws PortletException {
        boolean superUser = "superuser_no_cache".equals(this.getScope()) ? true : "superuser_context".equals(this.getScope());
        CMSController ctrl = new CMSController(this.getPortalCtx(), superUser);
        try {
            if (spacePath == null) {
                spacePath = this.getSpacePath();
            }
            if (spacePath != null) {
                UniversalID internalID;
                NuxeoRepository nuxeoRepository;
                if (documentPath != null) {
                    nuxeoRepository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(ctrl.getCMSContext(), NUXEO_REPOSITORY_NAME);
                    internalID = new UniversalID(NUXEO_REPOSITORY_NAME, nuxeoRepository.getInternalId(documentPath));
                } else {
                    internalID = null;
                }
                nuxeoRepository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(ctrl.getCMSContext(), NUXEO_REPOSITORY_NAME);
                UniversalID spaceID = new UniversalID(NUXEO_REPOSITORY_NAME, nuxeoRepository.getInternalId(spacePath));
                CMSSession session = ((CMSService)Locator.getService(CMSService.class)).getCMSSession(ctrl.getCMSContext());
                UpdateInformations infos = new UpdateInformations(internalID, spaceID, scope, async);
                session.notifyUpdate(infos);
                PageProperties.getProperties().setCheckingSpaceTS(Long.valueOf(System.currentTimeMillis()));
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public String getSpacePath(String documentPath) throws PortletException {
        CMSController ctrl = new CMSController(this.getPortalCtx());
        try {
            CMSSession session = ((CMSService)Locator.getService(CMSService.class)).getCMSSession(ctrl.getCMSContext());
            NuxeoRepository nuxeoRepository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(ctrl.getCMSContext(), NUXEO_REPOSITORY_NAME);
            UniversalID internalID = new UniversalID(NUXEO_REPOSITORY_NAME, nuxeoRepository.getInternalId(documentPath));
            Document doc = session.getDocument(internalID);
            Document space = session.getDocument(doc.getSpaceId());
            String spacePath = ((org.nuxeo.ecm.automation.client.model.Document)space.getNativeItem()).getPath();
            return spacePath;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public UniversalID getUniversalIDFromPath(String path) {
        try {
            return NuxeoController.getCMSService().getUniversalIDFromPath(this.getCMSCtx(), path);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public static String createFolderRequest(NuxeoDocumentContext documentContext, boolean ordered) {
        String nuxeoRequest = null;
        org.nuxeo.ecm.automation.client.model.Document document = documentContext.getDocument();
        NuxeoPublicationInfos publicationInfos = documentContext.getPublicationInfos();
        if (documentContext.isContextualized()) {
            nuxeoRequest = "ecm:parentId = '" + publicationInfos.getLiveId() + "' AND ecm:mixinType != 'Folderish'";
            nuxeoRequest = ordered ? nuxeoRequest + " order by ecm:pos" : nuxeoRequest + " order by dc:modified desc";
        } else {
            nuxeoRequest = "ecm:path STARTSWITH '" + NuxeoController.getLivePath(document.getPath()) + "' AND ecm:mixinType != 'Folderish' ";
            nuxeoRequest = ordered ? nuxeoRequest + " order by ecm:pos" : nuxeoRequest + " order by dc:modified desc";
        }
        return nuxeoRequest;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    private IDirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");
            this.directoryService = this.directoryServiceLocator.getDirectoryService();
        }
        return this.directoryService;
    }

    public String getDomainPath() {
        return this.domainPath;
    }

    public String getParentPathToCreate() {
        return this.parentPathToCreate;
    }

    public void setParentPathToCreate(String parentPathToCreate) {
        this.parentPathToCreate = parentPathToCreate;
    }

    public String getMenuRootPath() {
        return this.menuRootPath;
    }

    public String getForcedLivePath() {
        return this.forcedLivePath;
    }

    public boolean isStreamingSupport() {
        return this.streamingSupport;
    }

    public void setStreamingSupport(boolean streamingSupport) {
        this.streamingSupport = streamingSupport;
    }

    public IWebIdService getWebIdService() {
        if (this.webIdService == null) {
            this.webIdService = (IWebIdService)this.getPortalCtx().getPortletCtx().getAttribute("webIdService");
        }
        return this.webIdService;
    }

    public org.nuxeo.ecm.automation.client.model.Document getCurrentDoc() {
        return this.currentDoc;
    }

    public void setCurrentDoc(org.nuxeo.ecm.automation.client.model.Document currentDoc) {
        this.currentDoc = currentDoc;
        if (currentDoc != null) {
            // empty if block
        }
    }

    public String getSpacePath() {
        return this.spacePath;
    }

    public void setSpacePath(String spacePath) {
        this.spacePath = spacePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getNavigationPath() {
        return this.navigationPath;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public String getItemNavigationPath() {
        return this.itemNavigationPath;
    }

    public String getDisplayContext() {
        return this.displayContext;
    }

    public void setDisplayContext(String displayContext) {
        this.displayContext = displayContext;
    }

    public String getHideMetaDatas() {
        return this.hideMetaDatas;
    }

    public void setHideMetaDatas(String hideMetaDatas) {
        this.hideMetaDatas = hideMetaDatas;
    }

    public void setPageMarker(String pageMarker) {
        this.pageMarker = pageMarker;
    }

    public String getDisplayLiveVersion() {
        return this.displayLiveVersion;
    }

    public void setDisplayLiveVersion(String displayLiveVersion) {
        this.displayLiveVersion = displayLiveVersion;
    }

    public boolean isDisplayingLiveVersion() {
        boolean fDisplayLiveVersion = false;
        if ("1".equals(this.displayLiveVersion)) {
            fDisplayLiveVersion = true;
        }
        return fDisplayLiveVersion;
    }

    public String getForcePublicationInfosScope() {
        return this.forcePublicationInfosScope;
    }

    public void setForcePublicationInfosScope(String forcePublicationInfosScope) {
        this.forcePublicationInfosScope = forcePublicationInfosScope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
        this.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if ("anonymous".equals(scope)) {
            this.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
            this.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        } else if (scope != null && !"__nocache".equals(scope)) {
            this.setAuthType(NuxeoCommandContext.AUTH_TYPE_PROFIL);
            this.setScopeProfil(this.getProfilManager().getProfil(scope));
            this.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        }
        this.scope = scope;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int cacheType) {
        this.cacheType = cacheType;
    }

    public boolean isForceReload() {
        return this.forceReload;
    }

    public void setForceReload(boolean forceReload) {
        this.forceReload = forceReload;
    }

    private ProfilBean getScopeProfil() {
        return this.scopeProfil;
    }

    private void setScopeProfil(ProfilBean scopeProfil) {
        this.scopeProfil = scopeProfil;
    }

    public boolean isAsynchronousUpdates() {
        return this.asynchronousUpdates;
    }

    public void setAsynchronousUpdates(boolean asynchronousUpdates) {
        this.asynchronousUpdates = asynchronousUpdates;
    }

    public long getCacheTimeOut() {
        return this.cacheTimeOut;
    }

    public void setCacheTimeOut(long cacheTimeOut) {
        this.cacheTimeOut = cacheTimeOut;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public PortalControllerContext getPortalCtx() {
        if (this.portalCtx == null) {
            this.portalCtx = this.request != null ? new PortalControllerContext(this.getPortletCtx(), this.request, this.response) : (this.getServletRequest() != null ? new PortalControllerContext(this.getServletRequest()) : new PortalControllerContext(this.getPortletCtx()));
        }
        return this.portalCtx;
    }

    public PortletRequest getRequest() {
        return this.request;
    }

    public PortletResponse getResponse() {
        return this.response;
    }

    public PortletContext getPortletCtx() {
        return this.portletCtx;
    }

    public NuxeoException wrapNuxeoException(Exception e) {
        if (e instanceof CMSException) {
            CMSException cmsExc = (CMSException)((Object)e);
            if (cmsExc.getErrorCode() == 3) {
                return new NuxeoException(3);
            }
            if (cmsExc.getErrorCode() == 1) {
                return new NuxeoException(1);
            }
            return new NuxeoException(2, (Throwable)cmsExc);
        }
        if (e instanceof PortletException) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof CMSException) {
                CMSException cmsException = (CMSException)cause;
                return this.wrapNuxeoException((Exception)((Object)cmsException));
            }
            return new NuxeoException(e);
        }
        return new NuxeoException(e);
    }

    public void setDocTypeToCreate(String property) {
        this.docTypeToCreate = property;
    }

    @Deprecated
    public CMSItem getNavigationItem() {
        try {
            if (this.navItem == null && this.getNavigationPath() != null) {
                CMSServiceCtx cmsReadNavContext = new CMSServiceCtx();
                cmsReadNavContext.setPortalControllerContext(this.getPortalCtx());
                cmsReadNavContext.setScope(this.getNavigationScope());
                this.navItem = NuxeoController.getCMSService().getPortalNavigationItem(cmsReadNavContext, this.getSpacePath(), this.getNavigationPath());
            }
            return this.navItem;
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String getNavigationScope() {
        return this.navigationScope;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)Locator.getService(IPortalUrlFactory.class);
        }
        return this.urlFactory;
    }

    public INuxeoCommandService getNuxeoCommandService() {
        try {
            if (this.nuxeoCommandService == null) {
                this.nuxeoCommandService = NuxeoCommandServiceFactory.getNuxeoCommandService(this.portletCtx);
            }
            return this.nuxeoCommandService;
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public IProfilManager getProfilManager() {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)this.portletCtx.getAttribute("ProfileService");
        }
        return this.profilManager;
    }

    public IFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = (IFormatter)this.portletCtx.getAttribute("FormatterService");
        }
        return this.formatter;
    }

    public INuxeoService getNuxeoCMSService() {
        if (this.nuxeoCMSService == null) {
            this.nuxeoCMSService = (INuxeoService)this.getPortletCtx().getAttribute("NuxeoService");
            if (this.nuxeoCMSService == null) {
                this.nuxeoCMSService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
            }
        }
        return this.nuxeoCMSService;
    }

    public String getPageId() {
        return null;
    }

    public String getComputedPath(String portletPath) {
        String computedPath;
        if (portletPath == null) {
            computedPath = "";
        } else {
            String path;
            computedPath = portletPath;
            if (computedPath.contains(":")) {
                try {
                    UniversalID id = new UniversalID(portletPath);
                    NuxeoRepository repository = (NuxeoRepository)((CMSService)Locator.getService(CMSService.class)).getUserRepository(this.getCMSContext(), id.getRepositoryName());
                    computedPath = repository.getPath(id.getInternalID());
                }
                catch (Exception e) {
                    throw this.wrapNuxeoException(e);
                }
            }
            if (computedPath.contains("${basePath}")) {
                path = this.getBasePath();
                if (path == null) {
                    path = "";
                }
                computedPath = computedPath.replaceAll("\\$\\{basePath\\}", path);
            }
            if (computedPath.contains("${spacePath}")) {
                path = this.getSpacePath();
                if (path == null) {
                    path = "";
                }
                computedPath = computedPath.replaceAll("\\$\\{spacePath\\}", path);
            }
            if (computedPath.contains("${navigationPath}")) {
                path = this.getNavigationPath();
                if (path == null) {
                    path = "";
                }
                computedPath = computedPath.replaceAll("\\$\\{navigationPath\\}", path);
            }
            if (computedPath.contains("${contentPath}")) {
                path = this.getContentPath();
                if (path == null) {
                    path = "";
                }
                computedPath = computedPath.replaceAll("\\$\\{contentPath\\}", path);
            }
            if (computedPath.contains("${sitePath}")) {
                path = this.getMenuRootPath();
                if (path == null) {
                    path = "";
                }
                computedPath = computedPath.replaceAll("\\$\\{sitePath\\}", path);
            }
            if (computedPath.contains("${domainPath}")) {
                path = this.getDomainPath();
                if (path == null) {
                    path = "";
                }
                computedPath = computedPath.replaceAll("\\$\\{domainPath\\}", path);
            }
            if (computedPath.contains("${taskPath}")) {
                String path2;
                PortalWindow window = WindowFactory.getWindow((PortletRequest)this.request);
                String taskId = window.getProperty("osivia.taskbar.linked.id");
                if (StringUtils.isEmpty((String)taskId)) {
                    path2 = "";
                } else {
                    TaskbarTask linkedTask = null;
                    try {
                        List tasks = this.taskbarService.getTasks(this.portalCtx, this.spacePath, true);
                        for (TaskbarTask task : tasks) {
                            if (!taskId.equals(task.getId())) continue;
                            linkedTask = task;
                            break;
                        }
                    }
                    catch (PortalException portalException) {
                        // empty catch block
                    }
                    path2 = linkedTask == null ? "" : linkedTask.getPath();
                }
                computedPath = computedPath.replaceAll("\\$\\{taskPath\\}", path2);
            }
            if (computedPath.contains("${userWorkspacePath}")) {
                List userWorkspaces;
                try {
                    userWorkspaces = NuxeoController.getCMSService().getWorkspaces(this.getCMSCtx(), true, false);
                }
                catch (CMSException e) {
                    userWorkspaces = null;
                }
                CMSItem userWorkspace = CollectionUtils.isNotEmpty(userWorkspaces) && userWorkspaces.size() == 1 ? (CMSItem)userWorkspaces.get(0) : null;
                if (userWorkspace != null) {
                    computedPath = computedPath.replaceAll("\\$\\{userWorkspacePath\\}", userWorkspace.getCmsPath());
                }
            }
            if (StringUtils.isNotEmpty((String)computedPath) && !computedPath.startsWith(SLASH)) {
                computedPath = NuxeoController.webIdToFetchPath(computedPath);
            }
        }
        return computedPath;
    }

    public String getUserWorkspacePath() {
        String userWorkspacePath;
        try {
            CMSItem userWorkspace = NuxeoController.getCMSService().getUserWorkspace(this.getCMSCtx());
            userWorkspacePath = userWorkspace != null ? userWorkspace.getCmsPath() : null;
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
        return userWorkspacePath;
    }

    public String transformHTMLContent(String htmlContent) {
        try {
            INuxeoService nuxeoService = this.getNuxeoCMSService();
            return nuxeoService.getCMSCustomizer().transformHTMLContent(this.getCMSCtx(), htmlContent);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String transformNuxeoLink(String link) {
        try {
            INuxeoService nuxeoService = this.getNuxeoCMSService();
            return nuxeoService.getCMSCustomizer().transformLink(this.getCMSCtx(), link);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String formatScopeList(String selectedScope) {
        try {
            Window window = (Window)this.request.getAttribute("osivia.window");
            return this.getFormatter().formatScopeList((PortalObject)window, "scope", selectedScope);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String formatRequestFilteringPolicyList(String selectedRequestFilteringPolicy) {
        try {
            Window window = (Window)this.request.getAttribute("osivia.window");
            return this.getFormatter().formatRequestFilteringPolicyList((PortalObject)window, "requestFilteringPolicy", selectedRequestFilteringPolicy);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String formatDisplayLiveVersionList(String selectedVersion) {
        try {
            Window window = (Window)this.request.getAttribute("osivia.window");
            return this.getFormatter().formatDisplayLiveVersionList(this.getCMSCtx(), (PortalObject)window, "displayLiveVersion", selectedVersion);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    private ResourceURL createResourceURL() {
        if (this.response instanceof RenderResponse) {
            return ((RenderResponse)this.response).createResourceURL();
        }
        if (this.response instanceof ResourceResponse) {
            return ((ResourceResponse)this.response).createResourceURL();
        }
        return null;
    }

    @Deprecated
    public boolean isIdOrPathInLiveState(String originalPath) {
        if (this.isDisplayingLiveVersion()) {
            return true;
        }
        String path = "";
        try {
            if (originalPath.startsWith(SLASH)) {
                path = originalPath;
            } else {
                CMSPublicationInfos pubInfos = NuxeoController.getCMSService().getPublicationInfos(this.getCMSCtx(), originalPath);
                path = pubInfos.getDocumentPath();
            }
        }
        catch (CMSException e) {
            throw new RuntimeException(e);
        }
        return this.isPathInPageEditionState(path);
    }

    public String getBinaryURL(BinaryDescription binary) {
        try {
            return NuxeoController.getCMSService().getBinaryResourceURL(this.getCMSCtx(), binary).getUrl();
        }
        catch (CMSException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean isPathInPageEditionState(String path) {
        IContributionService.EditionState editionState;
        if (path.equals(this.getNavigationPath()) && path.equals(this.getRequest().getAttribute("osivia.cms.webPageEditionPath"))) {
            return true;
        }
        return this.getRequest() != null && (editionState = (IContributionService.EditionState)this.getRequest().getAttribute("osivia.editionState")) != null && IContributionService.EditionState.CONTRIBUTION_MODE_EDITION.equals(editionState.getContributionMode()) && editionState.getDocPath().equals(path);
    }

    public String createFileLink(String path, String fieldName, String fileName) {
        try {
            BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, path);
            binary.setDocument((Object)this.getCurrentDoc());
            binary.setFieldName(fieldName);
            binary.setFileName(fileName);
            return this.getBinaryURL(binary);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String createFileLink(org.nuxeo.ecm.automation.client.model.Document doc, String fieldName) {
        try {
            BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, doc.getPath());
            binary.setFieldName(fieldName);
            binary.setDocument((Object)doc);
            return this.getBinaryURL(binary);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String createFileLinkOfVersion(org.nuxeo.ecm.automation.client.model.Document version, String fieldName) {
        try {
            BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE_OF_VERSION, version.getPath());
            binary.setFieldName(fieldName);
            binary.setDocument((Object)version);
            return this.getBinaryURL(binary);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String createExternalLink(org.nuxeo.ecm.automation.client.model.Document doc) {
        ResourceURL resourceURL = this.createResourceURL();
        resourceURL.setResourceID(doc.getId());
        resourceURL.setParameter("type", "link");
        return resourceURL.toString();
    }

    public String createAttachedFileLink(String path, String fileIndex) {
        BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.ATTACHED_FILE, path);
        binary.setDocument((Object)this.getCurrentDoc());
        binary.setIndex(fileIndex);
        return this.getBinaryURL(binary);
    }

    public String createAttachedBlobLink(String path, String blobIndex, String fileName) {
        BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.BLOB, path);
        if (this.currentDoc != null && StringUtils.equals((String)path, (String)this.currentDoc.getPath())) {
            binary.setDocument((Object)this.currentDoc);
        }
        binary.setIndex(blobIndex);
        binary.setFileName(fileName);
        return this.getBinaryURL(binary);
    }

    public String createAttachedPictureLink(String path, String index, String fileName) {
        try {
            BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.ATTACHED_PICTURE, path);
            binary.setDocument((Object)this.getCurrentDoc());
            binary.setIndex(index);
            binary.setFileName(fileName);
            return this.getBinaryURL(binary);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String createPictureLink(String path, String content) {
        BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.PICTURE, path);
        binary.setContent(content);
        if (this.currentDoc != null && StringUtils.equals((String)path, (String)this.currentDoc.getPath())) {
            binary.setDocument((Object)this.currentDoc);
        }
        return this.getBinaryURL(binary);
    }

    public String createPermalink(String path) {
        try {
            String permaLinkURL = this.getPortalUrlFactory().getPermaLink(this.getPortalCtx(), null, null, path, "cms");
            return permaLinkURL;
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public URI getNuxeoPublicBaseUri() {
        if (this.nuxeoBaseURI == null) {
            this.nuxeoBaseURI = NuxeoConnectionProperties.getPublicBaseUri();
        }
        return this.nuxeoBaseURI;
    }

    public void handleErrors(NuxeoException e) throws PortletException {
        if (this.response instanceof RenderResponse) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)this.response, e);
        }
    }

    public Object executeNuxeoCommand(INuxeoCommand command) {
        PortalControllerContext portalCtx = this.request != null ? new PortalControllerContext(this.portletCtx, this.request, this.response) : (this.servletRequest != null ? new PortalControllerContext(this.servletRequest) : null);
        NuxeoCommandContext commandContext = portalCtx != null ? new NuxeoCommandContext(this.portletCtx, portalCtx) : new NuxeoCommandContext(this.portletCtx);
        commandContext.setAuthType(this.getAuthType());
        commandContext.setAuthProfil(this.getScopeProfil());
        commandContext.setCacheTimeOut(this.cacheTimeOut);
        commandContext.setCacheType(this.cacheType);
        commandContext.setAsynchronousUpdates(this.asynchronousUpdates);
        commandContext.setAsynchronousCommand(this.asynchronousCommand);
        commandContext.setSatellite(this.satellite);
        commandContext.setForceReload(this.forceReload);
        try {
            CMSContext cmsContext = this.getCMSContext();
            if (commandContext.getAuthType() == NuxeoCommandContext.AUTH_TYPE_SUPERUSER) {
                cmsContext.setSuperUserMode(true);
            }
            CMSSession cmsSession = ((CMSService)Locator.getService(CMSService.class)).getCMSSession(cmsContext);
            return ((NuxeoResult)cmsSession.executeRequest((Request)new NuxeoRequest(NUXEO_REPOSITORY_NAME, commandContext, command))).getResult();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public CMSContext getCMSContext() {
        PortalControllerContext ctx = this.getPortalCtx();
        CMSController ctrl = new CMSController(ctx);
        return ctrl.getCMSContext();
    }

    public void startNuxeoService() {
        try {
            NuxeoCommandServiceFactory.startNuxeoCommandService(this.getPortletCtx());
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public void stopNuxeoService() {
        try {
            NuxeoCommandServiceFactory.stopNuxeoCommandService(this.getPortletCtx());
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public Link getLink(org.nuxeo.ecm.automation.client.model.Document doc) {
        return this.getLink(doc, null);
    }

    public Link getLink(org.nuxeo.ecm.automation.client.model.Document doc, String displayContext) {
        return this.getLink(doc, displayContext, null);
    }

    public Link getLinkFromNuxeoURL(String url) {
        return this.getLinkFromNuxeoURL(url, null);
    }

    public Link getLinkFromNuxeoURL(String url, String displayContext) {
        INuxeoService nuxeoService = this.getNuxeoCMSService();
        INuxeoCustomizer nuxeoCustomizer = nuxeoService.getCMSCustomizer();
        return nuxeoCustomizer.getLinkFromNuxeoURL(this.getCMSCtx(), url, displayContext);
    }

    public Link getCMSLinkByPath(String path, String displayContext) {
        Window window = (Window)this.getPortalCtx().getRequest().getAttribute("osivia.window");
        Page page = window.getPage();
        HashMap parameters = new HashMap(0);
        String url = this.getPortalUrlFactory().getCMSUrl(this.portalCtx, page.getId().toString(PortalObjectPath.CANONICAL_FORMAT), path, parameters, null, displayContext, null, null, null, null);
        if (url != null) {
            Link link = new Link(url, false);
            return link;
        }
        return null;
    }

    public Link getLink(org.nuxeo.ecm.automation.client.model.Document doc, String displayContext, String linkContextualization) {
        try {
            String url;
            String localContextualization = linkContextualization;
            INuxeoService nuxeoService = this.getNuxeoCMSService();
            CMSServiceCtx handlerCtx = new CMSServiceCtx();
            handlerCtx.setPortalControllerContext(new PortalControllerContext(this.getPortletCtx(), this.getRequest(), this.getResponse()));
            if (this.response instanceof MimeResponse) {
                handlerCtx.setResponse((MimeResponse)this.response);
            }
            handlerCtx.setScope(this.getScope());
            handlerCtx.setDisplayLiveVersion(this.getDisplayLiveVersion());
            handlerCtx.setPageId(this.getPageId());
            handlerCtx.setDoc((Object)doc);
            handlerCtx.setHideMetaDatas(this.getHideMetaDatas());
            handlerCtx.setDisplayContext(displayContext);
            Link portletLink = nuxeoService.getCMSCustomizer().createCustomLink(handlerCtx);
            if (portletLink != null) {
                return portletLink;
            }
            if (!doc.getPath().startsWith("/default-domain/UserWorkspace")) {
                UniversalID id = this.getUniversalIDFromPath(doc.getPath());
                url = this.getPortalUrlFactory().getViewContentUrl(this.getPortalCtx(), this.getCMSContext(), id);
            } else {
                url = this.getPortalUrlFactory().getViewContentUrl(this.getPortalCtx(), this.getCMSContext(), new UniversalID(NUXEO_REPOSITORY_NAME, doc.getProperties().getString("ttc:webid")));
            }
            if (url != null) {
                Link link = new Link(url, false);
                return link;
            }
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
        return null;
    }

    public String getContentWebIdPath() {
        INuxeoService nuxeoService = this.getNuxeoCMSService();
        String path = nuxeoService.getCMSCustomizer().getContentWebIdPath(this.getCMSCtx());
        return path;
    }

    public void insertContentMenuBarItems() {
        try {
            INuxeoService nuxeoService = this.getNuxeoCMSService();
            nuxeoService.getCMSCustomizer().formatContentMenuBar(this.getCMSCtx());
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public INuxeoCommentsService getNuxeoCommentsService() {
        try {
            INuxeoService nuxeoService = this.getNuxeoCMSService();
            return nuxeoService.getCMSCustomizer().getNuxeoCommentsService();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    @Deprecated
    public String getCommentsHTMLContent() throws CMSException {
        try {
            CMSServiceCtx cmsContext = this.getCMSCtx();
            INuxeoService nuxeoService = this.getNuxeoCMSService();
            return nuxeoService.getCMSCustomizer().getCommentsHTMLContent(cmsContext, this.currentDoc);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public Map<String, DocumentType> getCMSItemTypes() {
        INuxeoService nuxeoService = this.getNuxeoCMSService();
        return nuxeoService.getCMSCustomizer().getCMSItemTypes();
    }

    @Deprecated
    public org.nuxeo.ecm.automation.client.model.Document fetchDocument(String path, boolean reload) {
        try {
            CMSServiceCtx cmsCtx = this.getCMSCtx();
            if (this.isPathInPageEditionState(path)) {
                cmsCtx.setDisplayLiveVersion("1");
            }
            if (reload) {
                cmsCtx.setForceReload(true);
            }
            CMSItem cmsItem = NuxeoController.getCMSService().getContent(cmsCtx, path);
            return (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public org.nuxeo.ecm.automation.client.model.Document fetchSharedDocument(String shareId, boolean enabledLinkOnly) {
        try {
            CMSServiceCtx cmsCtx = this.getCMSCtx();
            CMSItem cmsItem = NuxeoController.getCMSService().getByShareId(cmsCtx, shareId, enabledLinkOnly);
            return (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public org.nuxeo.ecm.automation.client.model.Document fetchSharedDocument(String shareId) {
        try {
            CMSServiceCtx cmsCtx = this.getCMSCtx();
            CMSItem cmsItem = NuxeoController.getCMSService().getByShareId(cmsCtx, shareId, true);
            return (org.nuxeo.ecm.automation.client.model.Document)cmsItem.getNativeItem();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    @Deprecated
    public org.nuxeo.ecm.automation.client.model.Document fetchDocument(String path) {
        return this.fetchDocument(path, false);
    }

    @Deprecated
    public String fetchLiveId(String path) {
        try {
            CMSPublicationInfos pubInfos = NuxeoController.getCMSService().getPublicationInfos(this.getCMSCtx(), path);
            return pubInfos.getLiveId();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public NuxeoQueryFilterContext getQueryFilterContextForPath(String path) {
        NuxeoQueryFilterContext queryCtx = new NuxeoQueryFilterContext();
        try {
            ICMSService cmsService = NuxeoController.getCMSService();
            CMSServiceCtx cmsContext = this.getCMSCtx();
            cmsContext.setForcePublicationInfosScope("superuser_context");
            CMSPublicationInfos pubInfos = cmsService.getPublicationInfos(cmsContext, path);
            if (pubInfos.isLiveSpace()) {
                queryCtx.setState(1);
            }
            return queryCtx;
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public CMSBinaryContent fetchAttachedPicture(String docPath, String pictureIndex) {
        try {
            return NuxeoController.getCMSService().getBinaryContent(this.getCMSCtx(), "attachedPicture", docPath, pictureIndex);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public CMSBinaryContent fetchPicture(String docPath, String content) {
        try {
            return NuxeoController.getCMSService().getBinaryContent(this.getCMSCtx(), "picture", docPath, content);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public CMSBinaryContent fetchFileContent(String docPath, String fieldName) {
        return this.fetchFileContent(docPath, fieldName, false);
    }

    public CMSBinaryContent fetchFileContent(String docPath, String fieldName, boolean reload) {
        try {
            ICMSService cmsService = NuxeoController.getCMSService();
            CMSServiceCtx cmsContext = this.getCMSCtx();
            cmsContext.setForceReload(reload);
            return cmsService.getBinaryContent(cmsContext, "file", docPath, fieldName);
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public String createUrlFromWebId(String webId, Map<String, String> parameters) throws CMSException {
        ICMSService cmsService = NuxeoController.getCMSService();
        IWebIdService webIdService = this.getWebIdService();
        INuxeoService nuxeoService = this.getNuxeoCMSService();
        INuxeoCustomizer cmsCustomizer = nuxeoService.getCMSCustomizer();
        IPortalUrlFactory portalUrlFactory = this.getPortalUrlFactory();
        PortalControllerContext portalControllerContext = this.getPortalCtx();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        String webIdPath = webIdService.webIdToFetchPath(webId);
        CMSItem content = cmsService.getContent(cmsContext, webIdPath);
        cmsContext.setDoc(content.getNativeItem());
        String path = cmsCustomizer.getContentWebIdPath(cmsContext);
        String url = portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
        try {
            URI originalUri = new URI(url);
            String query = originalUri.getQuery();
            boolean firstParameter = true;
            StringBuilder builder = new StringBuilder();
            if (query != null) {
                builder.append(query);
                firstParameter = false;
            }
            if (parameters != null) {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    if (firstParameter) {
                        firstParameter = false;
                    } else {
                        builder.append("&");
                    }
                    builder.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                    builder.append("=");
                    builder.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
                }
            }
            query = builder.toString();
            URI adaptedUri = new URI(originalUri.getScheme(), originalUri.getAuthority(), originalUri.getPath(), query, originalUri.getFragment());
            return adaptedUri.toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    public String createWebIdLink(String webid, String content) {
        try {
            Boolean permalinks = (Boolean)this.request.getAttribute("osivia.parameterized.permalinks");
            if (this.getRequest().getUserPrincipal() == null || BooleanUtils.isTrue((Boolean)permalinks)) {
                StringBuilder url = new StringBuilder();
                if (BooleanUtils.isTrue((Boolean)permalinks)) {
                    url.append(this.request.getScheme());
                    url.append("://");
                    url.append(this.request.getServerName());
                    url.append(":");
                    url.append(this.request.getServerPort());
                }
                url.append(this.getRequest().getContextPath());
                url.append("/sitepicture?path=");
                url.append(URLEncoder.encode(webid, "UTF-8"));
                if (content != null) {
                    url.append("&content=");
                    url.append(content);
                }
                return url.toString();
            }
            ResourceURL resourceURL = this.createResourceURL();
            resourceURL.setResourceID(webid);
            if (content != null) {
                resourceURL.setParameter("type", "picture");
                resourceURL.setParameter("docPath", webid);
                resourceURL.setParameter("content", content);
            }
            resourceURL.setCacheability("cacheLevelPage");
            return resourceURL.toString();
        }
        catch (Exception e) {
            throw this.wrapNuxeoException(e);
        }
    }

    public CMSServiceCtx getCMSCtx() {
        try {
            String refresh;
            boolean initPubInfosScope;
            this.cmsCtx = new CMSServiceCtx();
            this.cmsCtx.setPortalControllerContext(this.getPortalCtx());
            if (this.response instanceof MimeResponse) {
                this.cmsCtx.setResponse((MimeResponse)this.response);
            }
            if (StringUtils.isNotEmpty((String)this.getScope())) {
                this.cmsCtx.setScope(this.getScope());
                initPubInfosScope = true;
            } else {
                this.scope = NuxeoCommandContext.AUTH_TYPE_SUPERUSER == this.getAuthType() && CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT == this.getCacheType() ? "superuser_context" : (NuxeoCommandContext.AUTH_TYPE_SUPERUSER == this.getAuthType() && CacheInfo.CACHE_SCOPE_NONE == this.getCacheType() ? "superuser_no_cache" : (NuxeoCommandContext.AUTH_TYPE_USER == this.getAuthType() && CacheInfo.CACHE_SCOPE_PORTLET_SESSION == this.getCacheType() ? "user_session" : (NuxeoCommandContext.AUTH_TYPE_ANONYMOUS == this.getAuthType() && CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT == this.getCacheType() ? "anonymous" : null)));
                this.cmsCtx.setScope(this.scope);
                this.cmsCtx.setForcePublicationInfosScope(this.scope);
                initPubInfosScope = false;
            }
            if (initPubInfosScope) {
                this.cmsCtx.setForcePublicationInfosScope(this.getForcePublicationInfosScope());
            }
            this.cmsCtx.setDisplayLiveVersion(this.getDisplayLiveVersion());
            this.cmsCtx.setForcedLivePath(this.getForcedLivePath());
            if (this.getRequest() != null) {
                this.cmsCtx.setPageId(this.getPageId());
            }
            this.cmsCtx.setDoc((Object)this.getCurrentDoc());
            this.cmsCtx.setHideMetaDatas(this.getHideMetaDatas());
            this.cmsCtx.setDisplayContext(this.displayContext);
            this.cmsCtx.setCreationType(this.docTypeToCreate);
            if (this.parentPathToCreate != null) {
                this.cmsCtx.setCreationPath(this.getComputedPath(this.parentPathToCreate));
            }
            if (this.reloadResource) {
                this.cmsCtx.setForceReload(true);
            } else if (this.getServletRequest() != null && BooleanUtils.toBoolean((String)(refresh = this.getServletRequest().getParameter("refresh")))) {
                this.cmsCtx.setForceReload(true);
            }
            this.cmsCtx.setStreamingSupport(this.streamingSupport);
            this.cmsCtx.setSatellite(this.satellite);
            return this.cmsCtx;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String getDebugInfos() {
        String output = "";
        if ("1".equals(System.getProperty("nuxeo.debugHtml"))) {
            output = output + "<p class=\"nuxeo-debug\" align=\"center\">";
            output = output + "scope : " + this.getScope();
            output = output + "</p>";
            return output;
        }
        output = output + "<!--";
        output = output + "scope : " + this.getScope();
        output = output + "-->";
        return output;
    }

    public Link getUserAvatar(String username) throws CMSException {
        return this.getNuxeoCMSService().getCMSCustomizer().getUserAvatar(username);
    }

    public String refreshUserAvatar(String username) {
        this.getCMSCtx().getServletRequest().setAttribute("osivia.refreshPageLayout", (Object)Boolean.TRUE);
        return NuxeoController.getCMSService().refreshUserAvatar(this.getCMSCtx(), username);
    }

    public void refreshUserInfo(String username) {
        this.getCMSCtx().getServletRequest().setAttribute("osivia.refreshPageLayout", (Object)Boolean.TRUE);
    }

    @Deprecated
    public DirectoryPerson getPerson(String uid) {
        IDirectoryService service = this.getDirectoryService();
        DirectoryPerson p = null;
        if (service != null) {
            p = service.getPerson(uid);
        }
        return p;
    }

    public NuxeoDocumentContext getCurrentDocumentContext() {
        PortalWindow window = this.request == null ? null : WindowFactory.getWindow((PortletRequest)this.request);
        String currentPath = window == null ? null : window.getProperty("osivia.cms.uri");
        if (StringUtils.isEmpty((String)currentPath)) {
            currentPath = this.contentPath;
        }
        return this.getDocumentContext(currentPath);
    }

    public NuxeoDocumentContext getDocumentContext(String path) {
        NuxeoDocumentContext documentContext;
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = this.getCMSCtx();
        if (path == null) {
            documentContext = null;
        } else {
            try {
                documentContext = (NuxeoDocumentContext)cmsService.getDocumentContext(cmsContext, path, NuxeoDocumentContext.class);
            }
            catch (CMSException e) {
                throw this.wrapNuxeoException((Exception)((Object)e));
            }
        }
        return documentContext;
    }

    public boolean isAsynchronousCommand() {
        return this.asynchronousCommand;
    }

    public void setAsynchronousCommand(boolean asynchronousCommand) {
        this.asynchronousCommand = asynchronousCommand;
    }

    public static String getCMSNuxeoWebContextName() {
        if (cmsContextName == null) {
            INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
            return nuxeoService.getCMSCustomizer().getResourceContextPath();
        }
        return cmsContextName;
    }

    static {
        cmsContextName = null;
    }
}

