/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class NuxeoQueryFilter {
    private static final Pattern QUERY_FILTER_PATTERN = Pattern.compile("(.*)ORDER([ ]*)BY(.*)");

    public static CMSServiceCtx getCMSCtx() {
        CMSServiceCtx cmsCtx = new CMSServiceCtx();
        return cmsCtx;
    }

    public static String addPublicationFilter(NuxeoQueryFilterContext queryCtx, String nuxeoRequest, boolean ignoreNavigationElement) {
        INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        CMSServiceCtx ctx = NuxeoQueryFilter.getCMSCtx();
        String state = String.valueOf(queryCtx.getState());
        ctx.setDisplayLiveVersion(state);
        try {
            return nuxeoService.getCMSCustomizer().addPublicationFilter(ctx, nuxeoRequest, queryCtx.getPolicy(), ignoreNavigationElement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String addPublicationFilter(NuxeoQueryFilterContext queryCtx, String nuxeoRequest) {
        return NuxeoQueryFilter.addPublicationFilter(queryCtx, nuxeoRequest, true);
    }

    public static String addSearchFilter(NuxeoQueryFilterContext queryCtx, String nuxeoRequest) {
        INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        CMSServiceCtx ctx = NuxeoQueryFilter.getCMSCtx();
        try {
            return nuxeoService.getCMSCustomizer().addSearchFilter(ctx, nuxeoRequest, queryCtx.getPolicy());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final int getState(String version) {
        int state = 0;
        if (StringUtils.isNotBlank((String)version)) {
            if ("1".equals(version)) {
                state = 1;
            } else if ("2".equals(version)) {
                state = 2;
            }
        }
        return state;
    }
}

