/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public enum WorkspaceType {
    PUBLIC("glyphicons glyphicons-unlock", "success", true, false),
    PUBLIC_INVITATION(PUBLIC, false, false),
    PRIVATE("glyphicons glyphicons-lock", "warning", true, false),
    INVITATION(PRIVATE, false, false),
    UNCHANGEABLE("glyphicons glyphicons-government", "default", false, true);

    private final String id = this.name();
    private final String key;
    private final String icon;
    private final String color;
    private final boolean allowedInvitationRequests;
    private final boolean portalAdministratorRestriction;

    private WorkspaceType(String icon, String color, boolean allowedInvitationRequests, boolean portalAdministratorRestriction) {
        this.key = "WORKSPACE_TYPE_" + StringUtils.upperCase((String)this.name());
        this.icon = icon;
        this.color = color;
        this.allowedInvitationRequests = allowedInvitationRequests;
        this.portalAdministratorRestriction = portalAdministratorRestriction;
    }

    private WorkspaceType(WorkspaceType primaryType, boolean allowedInvitationRequests, boolean portalAdministratorRestriction) {
        this.key = primaryType.key;
        this.icon = primaryType.icon;
        this.color = primaryType.color;
        this.allowedInvitationRequests = allowedInvitationRequests;
        this.portalAdministratorRestriction = portalAdministratorRestriction;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isAllowedInvitationRequests() {
        return this.allowedInvitationRequests;
    }

    public static List<WorkspaceType> list(boolean admin) {
        ArrayList<WorkspaceType> results;
        WorkspaceType[] values = WorkspaceType.values();
        if (admin) {
            results = new ArrayList<WorkspaceType>(Arrays.asList(values));
        } else {
            results = new ArrayList(values.length);
            for (WorkspaceType value : values) {
                if (value.portalAdministratorRestriction) continue;
                results.add(value);
            }
        }
        return results;
    }

    public boolean isPortalAdministratorRestriction() {
        return this.portalAdministratorRestriction;
    }
}

