/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.nuxeo.ecm.automation.client.LoginInfo;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentServiceFactory;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpConnector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.ConnectorHandler;
import org.nuxeo.ecm.automation.client.jaxrs.spi.StreamedSession;
import org.nuxeo.ecm.automation.client.model.OperationRegistry;

public class HttpAutomationClient
extends AbstractAutomationClient {
    protected DefaultHttpClient http = new DefaultHttpClient();
    public static OperationRegistry sharedRegistry = null;
    public static Object sharedRegistrySynchronizer = new Object();
    public static long sharedRegistryUpdateTimestamp = 0L;
    private static long SHARED_REGISTRY_EXPIRATION_DELAY = 60000L;

    public HttpAutomationClient(String url) {
        super(url);
        this.registerAdapter(new DocumentServiceFactory());
    }

    public void setProxy(String host, int port) {
        this.http.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port));
    }

    public HttpClient http() {
        return this.http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        Connector connector = this.newConnector();
        if (this.requestInterceptor != null) {
            connector = new ConnectorHandler(connector, this.requestInterceptor);
        }
        if (this.registry == null) {
            if (System.currentTimeMillis() - sharedRegistryUpdateTimestamp < SHARED_REGISTRY_EXPIRATION_DELAY) {
                this.registry = sharedRegistry;
            } else {
                Object object = sharedRegistrySynchronizer;
                synchronized (object) {
                    if (System.currentTimeMillis() - sharedRegistryUpdateTimestamp < SHARED_REGISTRY_EXPIRATION_DELAY) {
                        this.registry = sharedRegistry;
                    } else {
                        sharedRegistry = this.registry = this.connect(connector);
                        sharedRegistryUpdateTimestamp = System.currentTimeMillis();
                    }
                }
            }
        }
        return this.login(connector);
    }

    @Override
    protected Session createSession(Connector connector, LoginInfo login) {
        return new StreamedSession(this, connector, login == null ? LoginInfo.ANONYNMOUS : login);
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.http.getConnectionManager().shutdown();
        this.http = null;
    }

    @Override
    protected Connector newConnector() {
        return new HttpConnector((HttpClient)this.http);
    }
}

