/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.AdapterFactory;

public class AdapterManager {
    protected Map<Class<?>, List<AdapterFactory<?>>> adapters;

    public <T> T getAdapter(Object objToAdapt, Class<T> adapterType) {
        Class<?> cls = objToAdapt.getClass();
        List<AdapterFactory<?>> factories = this.adapters.get(adapterType);
        if (factories != null) {
            for (AdapterFactory<?> f : factories) {
                if (!f.getAcceptType().isAssignableFrom(cls)) continue;
                return (T)f.getAdapter(objToAdapt);
            }
        }
        return null;
    }

    public void registerAdapter(AdapterFactory<?> factory) {
        Class<?> adapter = factory.getAdapterType();
        List<AdapterFactory<?>> factories = this.adapters.get(adapter);
        if (factories == null) {
            factories = new ArrayList();
            this.adapters.put(adapter, factories);
        }
        factories.add(factory);
    }
}

