/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.internet.MimeMultipart;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.impl.MultipartRequestEntity;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;

public class HttpConnector
implements Connector {
    protected final AbstractHttpClient http;
    protected final HttpContext ctx;
    protected String basicAuth;
    public int webServiceTimeOut = -1;

    public HttpConnector(HttpClient http) {
        this(http, (HttpContext)new BasicHttpContext());
    }

    public HttpConnector(HttpClient http, HttpContext ctx) {
        ctx.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
        this.http = (AbstractHttpClient)http;
        this.ctx = ctx;
        String wsTimeOut = System.getProperty("ws.webServiceTimeOut");
        if (wsTimeOut != null) {
            this.webServiceTimeOut = Integer.parseInt(wsTimeOut) * 1000;
        }
    }

    public HttpResponse getTimeoutRequest(HttpUriRequest httpReq) throws Exception {
        if (this.webServiceTimeOut != -1) {
            this.http.getParams().setParameter("http.socket.timeout", (Object)this.webServiceTimeOut);
            this.http.getParams().setParameter("http.connection-manager.timeout", (Object)this.webServiceTimeOut);
            this.http.getParams().setParameter("http.connection.timeout", (Object)this.webServiceTimeOut);
        }
        return this.http.execute(httpReq, this.ctx);
    }

    @Override
    public Object execute(Request request) {
        HttpGet httpRequest = null;
        if (request.getMethod() == 1) {
            HttpPost post = new HttpPost(request.getUrl());
            Object obj = request.getEntity();
            if (obj != null) {
                MultipartRequestEntity entity = null;
                if (request.isMultiPart()) {
                    entity = new MultipartRequestEntity((MimeMultipart)obj);
                } else {
                    try {
                        entity = new StringEntity(obj.toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("Cannot encode into UTF-8", e);
                    }
                }
                post.setEntity((HttpEntity)entity);
            }
            httpRequest = post;
        } else {
            httpRequest = new HttpGet(request.getUrl());
        }
        try {
            return this.execute(request, (HttpUriRequest)httpRequest);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot execute " + request, e);
        }
    }

    protected Object execute(Request request, HttpUriRequest httpReq) throws Exception {
        for (Map.Entry entry : request.entrySet()) {
            httpReq.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        HttpResponse resp = this.getTimeoutRequest(httpReq);
        HttpEntity entity = resp.getEntity();
        int status = resp.getStatusLine().getStatusCode();
        if (entity == null) {
            if (status < 400) {
                return null;
            }
            throw new RemoteException(status, "ServerError", "Server Error", "");
        }
        Header ctypeHeader = entity.getContentType();
        if (ctypeHeader == null) {
            if (status != 200) {
                throw new RemoteException(status, "ServerError", "Server Error", "");
            }
            return null;
        }
        String ctype = ctypeHeader.getValue().toLowerCase();
        String disp = null;
        Header[] hdisp = resp.getHeaders("Content-Disposition");
        if (hdisp != null && hdisp.length > 0) {
            disp = hdisp[0].getValue();
        }
        return request.handleResult(status, ctype, disp, entity.getContent());
    }
}

