/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DateUtils;
import org.nuxeo.ecm.automation.client.model.PropertiesHelper;
import org.nuxeo.ecm.automation.client.model.PropertyList;

public class PropertyMap
implements Serializable {
    private static final long serialVersionUID = -3260084599278006841L;
    protected final LinkedHashMap<String, Object> map;

    public PropertyMap() {
        this.map = new LinkedHashMap();
    }

    public PropertyMap(PropertyMap props) {
        this.map = new LinkedHashMap<String, Object>(props.map);
    }

    public PropertyMap(Map<String, Object> map) {
        this.map = new LinkedHashMap<String, Object>(map);
    }

    public PropertyMap(int size) {
        this.map = new LinkedHashMap(size);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public PropertyList getList(String key) {
        return this.getList(key, null);
    }

    public PropertyMap getMap(String key) {
        return this.getMap(key, null);
    }

    public String getString(String key, String defValue) {
        return PropertiesHelper.getString(this.map.get(key), defValue);
    }

    public Blob getBlob(String key) {
        Object v = this.map.get(key);
        if (v == null) {
            return null;
        }
        if (v instanceof Blob) {
            return (Blob)v;
        }
        throw new IllegalArgumentException("Property '" + key + "' is not a blob");
    }

    public Boolean getBoolean(String key, Boolean defValue) {
        return PropertiesHelper.getBoolean(this.map.get(key), defValue);
    }

    public Long getLong(String key, Long defValue) {
        return PropertiesHelper.getLong(this.map.get(key), defValue);
    }

    public Double getDouble(String key, Double defValue) {
        return PropertiesHelper.getDouble(this.map.get(key), defValue);
    }

    public Date getDate(String key, Date defValue) {
        return PropertiesHelper.getDate(this.map.get(key), defValue);
    }

    public PropertyList getList(String key, PropertyList defValue) {
        return PropertiesHelper.getList(this.map.get(key), defValue);
    }

    public PropertyMap getMap(String key, PropertyMap defValue) {
        return PropertiesHelper.getMap(this.map.get(key), defValue);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void set(String key, String value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value);
    }

    public void set(String key, Boolean value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value.toString());
    }

    public void set(String key, Long value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value.toString());
    }

    public void set(String key, Double value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value.toString());
    }

    public void set(String key, Date value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, DateUtils.formatDate(value));
    }

    public void set(String key, PropertyList value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value);
    }

    public void set(String key, PropertyMap value) {
        if (value == null) {
            this.map.remove(key);
        }
        this.map.put(key, value);
    }

    public Map<String, Object> map() {
        return this.map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object v = entry.getValue();
            if (v != null) {
                if (v.getClass() != String.class) continue;
                buf.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
                continue;
            }
            buf.append(entry.getKey()).append("=").append("\n");
        }
        return buf.toString();
    }

    public LinkedHashMap<String, Object> getMap() {
        return this.map;
    }
}

