/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.adapters;

import java.util.List;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.DocumentPermissions;
import org.nuxeo.ecm.automation.client.model.ListString;

public class DocumentSecurityService {
    public static final String LOCAL_ACL = "local";
    public static final String INHERITED_ACL = "inherited";
    public static final String ADD_PERMISSIONS_OP = "Document.AddACEs";
    public static final String REMOVE_PERMISSIONS_OP = "Document.RemoveACEs";
    public static final String REMOVE_GROUP_PERMISSIONS_OP = "Document.RemoveACL";
    protected Session session;

    public DocumentSecurityService(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public Document addPermissions(Document document, DocumentPermissions permissions, String acl, boolean blockInheritance) throws Exception {
        if (blockInheritance && INHERITED_ACL.equalsIgnoreCase(acl)) {
            throw new Exception("You can not add permissions in inherited ACL if you block inheritance");
        }
        OperationRequest request = this.getSession().newRequest(ADD_PERMISSIONS_OP).setInput(document).set("acl", acl).set("aces", permissions.toString()).set("blockInheritance", blockInheritance);
        return (Document)request.execute();
    }

    public Document removePermissions(DocRef docRef, DocumentPermissions permissions, List<String> userNames, String acl, boolean removeAll, boolean blockInheritance) throws Exception {
        if (blockInheritance && INHERITED_ACL.equalsIgnoreCase(acl)) {
            throw new Exception("You can not remove permissions in inherited ACL if you block inheritance");
        }
        OperationRequest request = this.getSession().newRequest(REMOVE_PERMISSIONS_OP).setInput(docRef).set("acl", acl).set("aces", permissions).set("userNames", ListString.getInstance().getAsString(userNames)).set("all", removeAll).set("blockInheritance", blockInheritance);
        return (Document)request.execute();
    }

    public Document removeGroupPermissions(DocRef docRef, String acl) throws Exception {
        OperationRequest request = this.getSession().newRequest(REMOVE_GROUP_PERMISSIONS_OP).setInput(docRef).set("acl", acl);
        return (Document)request.execute();
    }
}

