/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class RoleSecurityBinding
implements Serializable {
    private static final long serialVersionUID = 2723720035191741138L;
    private final String roleName;
    private final Set actions;
    private transient String toString;
    private transient int hashCode;
    private transient String actionsAsString;

    public RoleSecurityBinding(String actions, String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Actions cannot be null");
        }
        StringTokenizer tokens = new StringTokenizer(actions, ",");
        HashSet<String> set = new HashSet<String>();
        while (tokens.hasMoreTokens()) {
            set.add(tokens.nextToken().trim());
        }
        this.roleName = role;
        this.actions = Collections.unmodifiableSet(set);
    }

    public RoleSecurityBinding(Set actions, String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Actions cannot be null");
        }
        this.roleName = role;
        this.actions = Collections.unmodifiableSet(new HashSet(actions));
    }

    public RoleSecurityBinding(RoleSecurityBinding other) {
        if (other == null) {
            throw new IllegalArgumentException("The constraint to clone cannot be null");
        }
        this.roleName = other.roleName;
        this.actions = other.actions;
    }

    public Set getActions() {
        return this.actions;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getActionsAsString() {
        if (this.actionsAsString == null) {
            StringBuffer tmp = new StringBuffer();
            Iterator i = this.actions.iterator();
            while (i.hasNext()) {
                String action = (String)i.next();
                if (i.hasNext()) {
                    tmp.append(", ");
                }
                tmp.append(action);
            }
            this.actionsAsString = tmp.toString();
        }
        return this.actionsAsString;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer tmp = new StringBuffer("SecurityConstraint[actions=(");
            Iterator i = this.actions.iterator();
            while (true) {
                String action = (String)i.next();
                tmp.append(action);
                if (!i.hasNext()) break;
                tmp.append(", ");
            }
            tmp.append("),role=").append(this.roleName).append("]");
            this.toString = tmp.toString();
        }
        return this.toString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RoleSecurityBinding) {
            RoleSecurityBinding that = (RoleSecurityBinding)o;
            return ((Object)this.actions).equals(that.actions) && this.roleName.equals(that.roleName);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hashCode = ((Object)this.actions).hashCode();
            this.hashCode = hashCode = 29 * hashCode + this.roleName.hashCode();
        }
        return this.hashCode;
    }
}

