/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.HAPartitionImpl;
import org.jboss.naming.NamingServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Version;
import org.jgroups.jmx.JChannelFactoryMBean;
import org.jgroups.jmx.JmxConfigurator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClusterPartition
extends ServiceMBeanSupport
implements ClusterPartitionMBean {
    public static final String JGROUPS_JMX_DOMAIN = "jboss.jgroups";
    public static final String CHANNEL_JMX_ATTRIBUTES = "type=channel,cluster=";
    public static final String PROTOCOL_JMX_ATTRIBUTES = "type=protocol,cluster=";
    protected String partitionName = ServerConfigUtil.getDefaultPartitionName();
    protected String jgProps = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=64;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;max_xmit_size=8192):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(down_thread=false;up_thread=false;frag_size=8192):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    protected HAPartitionImpl partition;
    protected boolean deadlock_detection = false;
    protected boolean allow_sync_events = false;
    protected JChannelFactoryMBean multiplexer = null;
    protected String stackName = null;
    protected JChannel channel;
    protected Object debugger = null;
    protected boolean use_debugger = false;
    protected String nodeName = null;
    protected InetAddress nodeAddress = null;
    protected long state_transfer_timeout = 60000L;
    protected long method_call_timeout = 60000L;
    protected boolean channelRegistered;
    protected boolean protocolsRegistered;

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newName) {
        this.partitionName = newName;
    }

    public String getPartitionProperties() {
        if (this.channel != null) {
            return this.channel.getProperties();
        }
        if (this.multiplexer == null && this.stackName == null) {
            return this.jgProps;
        }
        return null;
    }

    public void setPartitionProperties(String newProps) {
        this.jgProps = newProps;
    }

    public void setPartitionConfig(Element config) {
        StringBuffer buffer = new StringBuffer();
        NodeList stack = config.getChildNodes();
        int length = stack.getLength();
        for (int s = 0; s < length; ++s) {
            Node node = stack.item(s);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            buffer.append(protocol);
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            if (attrLength > 0) {
                buffer.append('(');
            }
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                buffer.append(name);
                buffer.append('=');
                buffer.append(value);
                if (a >= attrLength - 1) continue;
                buffer.append(';');
            }
            if (attrLength > 0) {
                buffer.append(')');
            }
            buffer.append(':');
        }
        buffer.setLength(buffer.length() - 1);
        this.jgProps = buffer.toString();
        this.log.debug((Object)("Setting JGProps from xml to: " + this.jgProps));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String node) throws Exception {
        if (this.getState() == 6 || this.getState() == 3 || this.getState() == 2) {
            throw new Exception("Node name cannot be changed once the partition has been started");
        }
        this.nodeName = node;
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress address) {
        this.nodeAddress = address;
    }

    public String getJGroupsVersion() {
        return Version.version + "( " + "$Id: Version.java,v 1.42.2.6 2007/07/31 07:17:55 belaban Exp $" + ")";
    }

    public long getStateTransferTimeout() {
        return this.state_transfer_timeout;
    }

    public void setStateTransferTimeout(long timeout) {
        this.state_transfer_timeout = timeout;
    }

    public long getMethodCallTimeout() {
        return this.method_call_timeout;
    }

    public void setMethodCallTimeout(long timeout) {
        this.method_call_timeout = timeout;
    }

    public JChannelFactoryMBean getMultiplexer() {
        return this.multiplexer;
    }

    public void setMultiplexer(JChannelFactoryMBean muxFactory) {
        this.multiplexer = muxFactory;
    }

    public String getMultiplexerStack() {
        return this.stackName;
    }

    public void setMultiplexerStack(String stackName) {
        this.stackName = stackName;
    }

    public boolean getDeadlockDetection() {
        return this.deadlock_detection;
    }

    public void setDeadlockDetection(boolean doit) {
        this.deadlock_detection = doit;
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.allow_sync_events;
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.allow_sync_events = allowSync;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    public HAPartition getHAPartition() {
        return this.partition;
    }

    public Vector getCurrentView() {
        return this.partition.getCurrentView();
    }

    public String getName() {
        return this.partitionName;
    }

    protected void createService() throws Exception {
        this.log.debug((Object)"Creating JGroups JChannel");
        if (this.stackName != null && this.multiplexer != null) {
            this.channel = (JChannel)this.multiplexer.createMultiplexerChannel(this.stackName, this.getPartitionName());
        } else {
            this.channel = new JChannel(this.jgProps);
            this.registerChannelInJmx();
        }
        if (this.use_debugger && this.debugger == null) {
            this.startChannelDebugger();
        }
        this.channel.setOpt(5, (Object)Boolean.TRUE);
        this.channel.setOpt(6, (Object)Boolean.TRUE);
        this.log.debug((Object)"Creating HAPartition");
        this.partition = this.createPartition();
        this.log.debug((Object)("Initing HAPartition: " + this.partition));
        this.partition.init();
        this.log.debug((Object)"HAPartition initialized");
    }

    protected HAPartitionImpl createPartition() throws Exception {
        HAPartitionImpl result = new HAPartitionImpl(this.partitionName, this.channel, this.deadlock_detection, this.getServer());
        result.setStateTransferTimeout(this.state_transfer_timeout);
        result.setMethodCallTimeout(this.method_call_timeout);
        return result;
    }

    protected void startService() throws Exception {
        if (this.nodeName == null || "".equals(this.nodeName)) {
            this.nodeName = this.generateUniqueNodeName();
        }
        HashMap<String, byte[]> staticNodeName = new HashMap<String, byte[]>();
        staticNodeName.put("additional_data", this.nodeName.getBytes());
        Class[] paramTypes = new Class[]{Event.class};
        Method downMethod = JChannel.class.getDeclaredMethod("down", paramTypes);
        Object[] params = new Object[]{new Event(56, staticNodeName)};
        downMethod.invoke((Object)this.channel, params);
        this.channel.getProtocolStack().flushEvents();
        this.log.debug((Object)("Starting ClusterPartition: " + this.partitionName));
        this.channel.connect(this.partitionName);
        try {
            this.log.debug((Object)"Starting channel");
            this.partition.startPartition();
            this.log.debug((Object)("Started ClusterPartition: " + this.partitionName));
        }
        catch (Exception e) {
            this.log.debug((Object)("Caught exception after channel connected; closing channel -- " + e.getLocalizedMessage()));
            this.channel.disconnect();
            throw e;
        }
    }

    protected void stopService() throws Exception {
        this.stopChannelDebugger();
        this.log.debug((Object)("Stopping ClusterPartition: " + this.partitionName));
        this.partition.closePartition();
        this.log.debug((Object)("Stopped ClusterPartition: " + this.partitionName));
    }

    protected void destroyService() throws Exception {
        this.log.debug((Object)("Destroying ClusterPartition: " + this.partitionName));
        this.partition.destroyPartition();
        this.unregisterChannelFromJmx();
        this.log.debug((Object)("Destroyed ClusterPartition: " + this.partitionName));
    }

    protected String generateUniqueNodeName() throws Exception {
        String hostIP = null;
        InetAddress address = ServerConfigUtil.fixRemoteAddress((InetAddress)this.nodeAddress);
        if (address == null) {
            this.log.debug((Object)"unable to create a GUID for this cluster, check network configuration is correctly setup (getLocalHost has returned an exception)");
            this.log.debug((Object)"using a full GUID strategy");
            return new VMID().toString();
        }
        hostIP = address.getHostAddress();
        try {
            AttributeList al = this.server.getAttributes(NamingServiceMBean.OBJECT_NAME, new String[]{"State", "Port"});
            int status = (Integer)((Attribute)al.get(0)).getValue();
            if (status == 3) {
                int port = (Integer)((Attribute)al.get(1)).getValue();
                return hostIP + ":" + port;
            }
            this.log.debug((Object)"JNDI has been found but the service wasn't started so we cannot be entirely sure we are the only one that wants to use this PORT as a GUID on this host.");
        }
        catch (InstanceNotFoundException e) {
            this.log.debug((Object)"JNDI not running here, cannot use this strategy to find a node GUID for the cluster");
        }
        catch (ReflectionException e) {
            this.log.debug((Object)"JNDI querying has returned an exception, cannot use this strategy to find a node GUID for the cluster");
        }
        String uid = new UID().toString();
        return hostIP + ":" + uid;
    }

    public String showHistory() {
        StringBuffer buff = new StringBuffer();
        Vector data = new Vector(this.partition.history);
        for (String info : data) {
            buff.append(info).append("\n");
        }
        return buff.toString();
    }

    public String showHistoryAsXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<events>\n");
        Vector data = new Vector(this.partition.history);
        Iterator row = data.iterator();
        while (row.hasNext()) {
            buff.append("   <event>\n      ");
            String info = (String)row.next();
            buff.append(info);
            buff.append("\n   </event>\n");
        }
        buff.append("</events>\n");
        return buff.toString();
    }

    public void startChannelDebugger() {
        this.startChannelDebugger(false);
    }

    public void startChannelDebugger(boolean accumulative) {
        if (this.debugger == null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("org.jgroups.debug.Debugger");
                Constructor<?> ctor = clazz.getConstructor(JChannel.class, Boolean.TYPE);
                this.debugger = ctor.newInstance(this.channel, accumulative);
                Method start = clazz.getDeclaredMethod("start", new Class[0]);
                start.invoke(this.debugger, new Object[0]);
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to start Debugger", (Throwable)e);
            }
        }
    }

    public void stopChannelDebugger() {
        if (this.debugger != null) {
            Class<?> clazz = this.debugger.getClass();
            try {
                Method stop = clazz.getDeclaredMethod("stop", new Class[0]);
                stop.invoke(this.debugger, new Object[0]);
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to cleanly stop Debugger", (Throwable)e);
            }
            this.debugger = null;
        }
    }

    protected void registerChannelInJmx() {
        if (this.server != null) {
            try {
                String protocolPrefix = "jboss.jgroups:type=protocol,cluster=" + this.getPartitionName();
                JmxConfigurator.registerProtocols((MBeanServer)this.server, (JChannel)this.channel, (String)protocolPrefix);
                this.protocolsRegistered = true;
                String name = "jboss.jgroups:type=channel,cluster=" + this.getPartitionName();
                JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)this.server, (String)name);
                this.channelRegistered = true;
            }
            catch (Exception e) {
                this.log.error((Object)"Caught exception registering channel in JXM", (Throwable)e);
            }
        }
    }

    protected void unregisterChannelFromJmx() {
        ObjectName on = null;
        if (this.channelRegistered) {
            try {
                on = new ObjectName("jboss.jgroups:type=channel,cluster=" + this.getPartitionName());
                this.server.unregisterMBean(on);
            }
            catch (Exception e) {
                if (on != null) {
                    this.log.error((Object)("Caught exception unregistering channel at " + on), (Throwable)e);
                }
                this.log.error((Object)"Caught exception unregistering channel", (Throwable)e);
            }
        }
        if (this.protocolsRegistered) {
            try {
                on = new ObjectName("jboss.jgroups:*,type=protocol,cluster=" + this.getPartitionName());
                Set<ObjectName> mbeans = this.server.queryNames(on, null);
                if (mbeans != null) {
                    Iterator<ObjectName> it = mbeans.iterator();
                    while (it.hasNext()) {
                        this.server.unregisterMBean(it.next());
                    }
                }
            }
            catch (Exception e) {
                if (on != null) {
                    this.log.error((Object)("Caught exception unregistering protocols at " + on), (Throwable)e);
                }
                this.log.error((Object)"Caught exception unregistering protocols", (Throwable)e);
            }
        }
    }
}

