/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class BMTInterceptor
implements Interceptor {
    private TransactionManager tm;
    private boolean isStateless;
    protected static Logger log = Logger.getLogger(BMTInterceptor.class);

    public BMTInterceptor(TransactionManager tm, boolean stateless) {
        this.tm = tm;
        this.isStateless = stateless;
    }

    public String getName() {
        return BMTInterceptor.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Object handleStateless(Invocation invocation) throws Throwable {
        Container container = (Container)invocation.getAdvisor();
        boolean exceptionThrown = false;
        try {
            Object object;
            try {
                object = invocation.invokeNext();
                Object var6_6 = null;
            }
            catch (Exception ex) {
                exceptionThrown = true;
                this.checkStatelessDone(container, ex);
                throw ex;
            }
            try {
                if (!exceptionThrown) {
                    this.checkStatelessDone(container, null);
                }
                Object var8_8 = null;
                this.tm.suspend();
                return object;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.tm.suspend();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                this.tm.suspend();
                throw throwable2;
            }
            if (!exceptionThrown) {
                this.checkStatelessDone(container, null);
            }
            Object var8_10 = null;
            this.tm.suspend();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleStateful(Invocation invocation) throws Throwable {
        Object object;
        EJBContainerInvocation ejb = (EJBContainerInvocation)invocation;
        Container container = (Container)invocation.getAdvisor();
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        Transaction tx = (Transaction)ctx.getMetaData().getMetaData((Object)"TX", (Object)"TX");
        if (tx != null) {
            ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", null, PayloadKey.TRANSIENT);
            this.tm.resume(tx);
        }
        try {
            object = invocation.invokeNext();
            Object var8_7 = null;
            this.checkBadStateful(container);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.checkBadStateful(container);
            Transaction newTx = this.tm.getTransaction();
            if (newTx != null) {
                ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", (Object)newTx, PayloadKey.TRANSIENT);
                this.tm.suspend();
            } else {
                ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", null, PayloadKey.TRANSIENT);
            }
            throw throwable;
        }
        Transaction newTx = this.tm.getTransaction();
        if (newTx != null) {
            ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", (Object)newTx, PayloadKey.TRANSIENT);
            this.tm.suspend();
        } else {
            ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", null, PayloadKey.TRANSIENT);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        block6: {
            Transaction oldTx;
            block4: {
                Object object2;
                block5: {
                    oldTx = this.tm.getTransaction();
                    if (oldTx != null) {
                        this.tm.suspend();
                    }
                    try {
                        if (!this.isStateless) break block4;
                        object2 = this.handleStateless(invocation);
                        Object var5_5 = null;
                        if (oldTx == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var5_7 = null;
                            if (oldTx == null) break block7;
                            this.tm.resume(oldTx);
                        }
                        throw throwable;
                    }
                    this.tm.resume(oldTx);
                }
                return object2;
            }
            object = this.handleStateful(invocation);
            Object var5_6 = null;
            if (oldTx == null) break block6;
            this.tm.resume(oldTx);
        }
        return object;
    }

    private void checkStatelessDone(Container container, Exception ex) {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException sex) {
            log.error((Object)"Failed to get status", (Throwable)sex);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception sex) {
                    log.error((Object)"Failed to rollback", (Throwable)sex);
                }
            }
            case 2: {
                String msg = "Application error: BMT stateless bean " + container.getEjbName() + " should complete transactions before" + " returning (EJB3 13.6.1)";
                log.error((Object)msg);
                if (ex != null) {
                    if (ex instanceof EJBException) {
                        throw (EJBException)((Object)ex);
                    }
                    throw new EJBException(msg, ex);
                }
                throw new EJBException(msg);
            }
        }
    }

    private void checkBadStateful(Container container) {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    log.error((Object)"Failed to rollback", (Throwable)ex);
                }
                String msg = "BMT stateful bean '" + container.getEjbName() + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString((int)status);
                log.error((Object)msg);
            }
        }
    }
}

