/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.faces;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import javax.portlet.PortletRequest;
import org.jboss.logging.Logger;

public class PortletVariableResolver
extends VariableResolver {
    private VariableResolver delegate;
    private static final String PORTLET_CONFIG = "portletConfig";
    private static final String PORTLET_SESSION_SCOPE = "sessionPortletScope";
    private static final String PORTLET_APPLICATION_SCOPE = "portletApplicationScope";
    private static final String PORTLET_RENDER_PARAMETER = "portletRenderParameter";
    private static final String PORTLET_PREFERENCE_VALUE = "portletPreferenceValue";
    private static final String PORTLET_PREFERENCE_VALUES = "portletPreferenceValues";
    private static final Logger log = Logger.getLogger(PortletVariableResolver.class);

    public PortletVariableResolver(VariableResolver delegate) {
        this.delegate = delegate;
    }

    public Object resolveVariable(FacesContext facesContext, String variable) throws EvaluationException {
        ExternalContext ectx = facesContext.getExternalContext();
        if (PORTLET_SESSION_SCOPE.equals(variable)) {
            return ectx.getSessionMap();
        }
        if (PORTLET_APPLICATION_SCOPE.equals(variable)) {
            return ectx.getApplicationMap();
        }
        if (PORTLET_RENDER_PARAMETER.equals(variable)) {
            return this.getRenderValueMap(ectx);
        }
        if (PORTLET_PREFERENCE_VALUE.equals(variable)) {
            return this.getValueMap(ectx);
        }
        if (PORTLET_PREFERENCE_VALUES.equals(variable)) {
            PortletRequest request = (PortletRequest)ectx.getRequest();
            return request.getPreferences().getMap();
        }
        return this.delegate.resolveVariable(facesContext, variable);
    }

    private Map getValueMap(ExternalContext ectx) {
        HashMap<String, String> map = new HashMap<String, String>();
        PortletRequest request = (PortletRequest)ectx.getRequest();
        Enumeration en = request.getPreferences().getNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = request.getPreferences().getValue(key, null);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private Map getRenderValueMap(ExternalContext ectx) {
        HashMap<String, String> map = new HashMap<String, String>();
        PortletRequest request = (PortletRequest)ectx.getRequest();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = request.getParameter(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }
}

