/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.handler;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.util.MultiValuedPropertyMap;
import org.jboss.portal.core.controller.handler.HandlerResponse;
import org.jboss.portal.server.ServerInvocationContext;

public abstract class HTTPResponse
extends HandlerResponse {
    public abstract void sendResponse(ServerInvocationContext var1) throws IOException, ServletException;

    public static HTTPResponse sendRedirect(final String redirect) {
        return new HTTPResponse(){

            @Override
            public void sendResponse(ServerInvocationContext ctx) throws IOException {
                HttpServletResponse resp = ctx.getClientResponse();
                resp.sendRedirect(redirect);
            }
        };
    }

    public static HTTPResponse sendBinary(final String contentType, final long lastModified, final MultiValuedPropertyMap<String> properties, final InputStream in) {
        return new HTTPResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResponse(ServerInvocationContext ctx) throws IOException {
                HttpServletResponse resp = ctx.getClientResponse();
                resp.setContentType(contentType);
                if (lastModified > 0L) {
                    resp.addDateHeader("Last-Modified", lastModified);
                }
                if (properties != null) {
                    for (String key : properties.keySet()) {
                        if (properties.getValue(key) == null) continue;
                        if (key.equals("portlet.http-status-code")) {
                            resp.setStatus(Integer.parseInt((String)properties.getValue(key)));
                            continue;
                        }
                        resp.setHeader(key, (String)properties.getValue(key));
                    }
                }
                ServletOutputStream sout = null;
                try {
                    sout = resp.getOutputStream();
                    IOTools.copy((InputStream)in, (OutputStream)sout);
                }
                finally {
                    IOTools.safeClose((Closeable)in);
                    IOTools.safeClose((Closeable)sout);
                }
            }
        };
    }

    public static HTTPResponse sendBinary(final String contentType, final long lastModified, final MultiValuedPropertyMap<String> properties, final Reader reader) {
        return new HTTPResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResponse(ServerInvocationContext ctx) throws IOException {
                HttpServletResponse resp = ctx.getClientResponse();
                resp.setContentType(contentType);
                if (lastModified > 0L) {
                    resp.addDateHeader("Last-Modified", lastModified);
                }
                if (properties != null) {
                    for (String key : properties.keySet()) {
                        if (properties.getValue(key) == null) continue;
                        if (key.equals("portlet.http-status-code")) {
                            resp.setStatus(Integer.parseInt((String)properties.getValue(key)));
                            continue;
                        }
                        resp.setHeader(key, (String)properties.getValue(key));
                    }
                }
                PrintWriter writer = null;
                try {
                    writer = resp.getWriter();
                    IOTools.copy((Reader)reader, (Writer)writer);
                }
                finally {
                    IOTools.safeClose((Closeable)reader);
                    IOTools.safeClose((Closeable)writer);
                }
            }
        };
    }

    public static HTTPResponse sendForbidden() {
        return HTTPResponse.sendStatus(403, null);
    }

    public static HTTPResponse sendNotFound() {
        return HTTPResponse.sendStatus(404, null);
    }

    public static HTTPResponse sendError() {
        return HTTPResponse.sendStatus(500, null);
    }

    public static HTTPResponse sendForbidden(String message) {
        return HTTPResponse.sendStatus(403, message);
    }

    public static HTTPResponse sendNotFound(String message) {
        return HTTPResponse.sendStatus(404, message);
    }

    public static HTTPResponse sendError(String message) {
        return HTTPResponse.sendStatus(500, message);
    }

    private static HTTPResponse sendStatus(final int statusCode, final String message) {
        return new HTTPResponse(){

            @Override
            public void sendResponse(ServerInvocationContext ctx) throws IOException {
                HttpServletResponse resp = ctx.getClientResponse();
                if (message == null) {
                    resp.sendError(statusCode);
                } else {
                    resp.sendError(statusCode, message);
                }
            }
        };
    }
}

