/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.component.portlet;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.faces.component.portlet.JSFInvocation;
import org.jboss.portal.faces.component.portlet.PortletEvent;
import org.jboss.portal.faces.component.portlet.UIPortlet;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletActionEvent
extends PortletEvent {
    private final Map<String, String[]> interactionState;
    private Mode mode;
    private WindowState windowState;
    protected PortletInvocationResponse pir;

    PortletActionEvent(UIComponent uiComponent, Map<String, String[]> interactionState, Mode mode, WindowState windowState) {
        super(uiComponent);
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (windowState == null) {
            throw new IllegalArgumentException();
        }
        this.interactionState = interactionState;
        this.mode = mode;
        this.windowState = windowState;
    }

    public Map<String, String[]> getParameterMap() {
        return this.interactionState;
    }

    public String getMode() {
        return this.mode.toString();
    }

    public void setMode(String mode) {
        if (mode == null) {
            throw new IllegalArgumentException("No mode provided");
        }
        this.mode = Mode.create((String)mode);
    }

    public String getWindowState() {
        return this.windowState.toString();
    }

    public void setWindowState(String windowState) {
        if (this.mode == null) {
            throw new IllegalArgumentException("No window state provided");
        }
        this.windowState = WindowState.create((String)windowState);
    }

    @Override
    void execute(FacesContext faces) {
        UIPortlet uiportlet = (UIPortlet)this.getComponent();
        Portlet portlet = uiportlet.getPortlet();
        JSFInvocation invocation = new JSFInvocation(faces, uiportlet);
        try {
            this.pir = invocation.action(portlet, this.mode, this.windowState, (StateString)ParametersStateString.create(this.interactionState));
            if (this.pir instanceof UpdateNavigationalStateResponse) {
                UpdateNavigationalStateResponse response = (UpdateNavigationalStateResponse)this.pir;
                uiportlet.setInternalNavState(((ParametersStateString)response.getNavigationalState()).getParameters());
                if (response.getWindowState() != null) {
                    uiportlet.setInternalWindowState(response.getWindowState());
                }
                if (response.getMode() != null) {
                    uiportlet.setInternalMode(response.getMode());
                }
            }
        }
        catch (PortletInvokerException e) {
            e.printStackTrace();
        }
    }
}

