/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.faces.el;

import javax.faces.el.PropertyNotFoundException;
import junit.framework.TestCase;
import org.jboss.portal.faces.el.DelegatingPropertyResolver;
import org.jboss.portal.test.faces.el.TestBean;
import org.jboss.portal.test.faces.el.TestBeanDecorator;
import org.jboss.portal.test.faces.el.TestBeanInterface;
import org.jboss.portal.test.faces.el.TestBeanInterfaceSuperInterface;
import org.jboss.portal.test.faces.el.TestBeanSuperClass;
import org.jboss.portal.test.faces.el.TestDynamicBean;
import org.jboss.portal.test.faces.el.Value;

public class DelegatingPropertyResolverTestCase
extends TestCase {
    private Object propertyName;
    private Object bean;
    private TestBean testBean;
    private TestBeanDecorator testBeanDecorator;
    private TestBeanDecorator testBeanInterfaceDecorator;
    private TestBeanDecorator testBeanInterfaceSuperInterfaceDecorator;
    private TestBeanDecorator testBeanSuperClassDecorator;
    private TestDynamicBean testDynamicBean;
    private DelegatingPropertyResolver resolver;

    protected void setUp() throws Exception {
        this.propertyName = new Object();
        this.bean = new Object();
        this.testBean = new TestBean();
        this.testBeanDecorator = new TestBeanDecorator(this.testBean.property);
        this.testBeanInterfaceDecorator = new TestBeanDecorator(this.testBean.interfaceProperty);
        this.testBeanInterfaceSuperInterfaceDecorator = new TestBeanDecorator(this.testBean.interfaceSuperInterfaceProperty);
        this.testBeanSuperClassDecorator = new TestBeanDecorator(this.testBean.superClassProperty);
        this.testDynamicBean = new TestDynamicBean();
        this.resolver = new DelegatingPropertyResolver();
        this.resolver.registerDecorator(TestBean.class, this.testBeanDecorator);
        this.resolver.registerDecorator(TestBeanInterface.class, this.testBeanInterfaceDecorator);
        this.resolver.registerDecorator(TestBeanInterfaceSuperInterface.class, this.testBeanInterfaceSuperInterfaceDecorator);
        this.resolver.registerDecorator(TestBeanSuperClass.class, this.testBeanSuperClassDecorator);
    }

    public void testGetType() {
        try {
            this.resolver.getType(this.bean, this.propertyName);
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        try {
            this.resolver.getType((Object)this.testBean, new Object());
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        DelegatingPropertyResolverTestCase.assertEquals(Value.class, (Object)this.resolver.getType((Object)this.testBean, this.testBeanDecorator.property.name));
        DelegatingPropertyResolverTestCase.assertEquals(Value.class, (Object)this.resolver.getType((Object)this.testBean, this.testBeanInterfaceDecorator.property.name));
        DelegatingPropertyResolverTestCase.assertEquals(Value.class, (Object)this.resolver.getType((Object)this.testBean, this.testBeanInterfaceSuperInterfaceDecorator.property.name));
        DelegatingPropertyResolverTestCase.assertEquals(Value.class, (Object)this.resolver.getType((Object)this.testBean, this.testBeanSuperClassDecorator.property.name));
        try {
            this.resolver.getType((Object)this.testDynamicBean, new Object());
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        DelegatingPropertyResolverTestCase.assertEquals(Value.class, (Object)this.resolver.getType((Object)this.testDynamicBean, this.testDynamicBean.propertyName));
    }

    public void testIsReadOnly() {
        try {
            this.resolver.isReadOnly(this.bean, this.propertyName);
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
    }

    public void testGetValue() {
        try {
            this.resolver.getValue(this.bean, this.propertyName);
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        try {
            this.resolver.getType((Object)this.testBean, new Object());
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        DelegatingPropertyResolverTestCase.assertEquals((Object)this.testBean.property.value, (Object)this.resolver.getValue((Object)this.testBean, this.testBeanDecorator.property.name));
        DelegatingPropertyResolverTestCase.assertEquals((Object)this.testBeanInterfaceDecorator.property.value, (Object)this.resolver.getValue((Object)this.testBean, this.testBeanInterfaceDecorator.property.name));
        DelegatingPropertyResolverTestCase.assertEquals((Object)this.testBeanInterfaceSuperInterfaceDecorator.property.value, (Object)this.resolver.getValue((Object)this.testBean, this.testBeanInterfaceSuperInterfaceDecorator.property.name));
        DelegatingPropertyResolverTestCase.assertEquals((Object)this.testBeanSuperClassDecorator.property.value, (Object)this.resolver.getValue((Object)this.testBean, this.testBeanSuperClassDecorator.property.name));
        try {
            this.resolver.getType((Object)this.testDynamicBean, new Object());
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        DelegatingPropertyResolverTestCase.assertEquals((Object)this.testDynamicBean.propertyValue, (Object)this.resolver.getValue((Object)this.testDynamicBean, this.testDynamicBean.propertyName));
    }

    public void testSetValue() {
        try {
            this.resolver.setValue(this.bean, this.propertyName, null);
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        try {
            this.resolver.setValue((Object)this.testBean, new Object(), null);
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        Value propertyExpectedValue = new Value();
        this.resolver.setValue((Object)this.testBean, this.testBeanDecorator.property.name, (Object)propertyExpectedValue);
        DelegatingPropertyResolverTestCase.assertEquals((Object)propertyExpectedValue, (Object)this.testBeanDecorator.property.value);
        Value interfacePropertyExpectedValue = new Value();
        this.resolver.setValue((Object)this.testBean, this.testBeanInterfaceDecorator.property.name, (Object)interfacePropertyExpectedValue);
        DelegatingPropertyResolverTestCase.assertEquals((Object)interfacePropertyExpectedValue, (Object)this.testBeanInterfaceDecorator.property.value);
        Value interfaceSuperInterfacePropertyExpectedValue = new Value();
        this.resolver.setValue((Object)this.testBean, this.testBeanInterfaceSuperInterfaceDecorator.property.name, (Object)interfaceSuperInterfacePropertyExpectedValue);
        DelegatingPropertyResolverTestCase.assertEquals((Object)interfaceSuperInterfacePropertyExpectedValue, (Object)this.testBeanInterfaceSuperInterfaceDecorator.property.value);
        Value superClassPropertyExpectedValue = new Value();
        this.resolver.setValue((Object)this.testBean, this.testBeanSuperClassDecorator.property.name, (Object)superClassPropertyExpectedValue);
        DelegatingPropertyResolverTestCase.assertEquals((Object)superClassPropertyExpectedValue, (Object)this.testBeanSuperClassDecorator.property.value);
        try {
            this.resolver.setValue((Object)this.testDynamicBean, new Object(), null);
            DelegatingPropertyResolverTestCase.fail((String)"Was expecting PNFE");
        }
        catch (PropertyNotFoundException expected) {
            // empty catch block
        }
        this.resolver.setValue((Object)this.testDynamicBean, this.testDynamicBean.propertyName, (Object)propertyExpectedValue);
        DelegatingPropertyResolverTestCase.assertEquals((Object)propertyExpectedValue, (Object)this.testDynamicBean.propertyValue);
    }
}

