/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.portlet;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.osivia.portal.api.portlet.PortletStatus;

public class PortletStatusContainer
implements Cloneable {
    private final Map<PortletKey, PortletStatus> map = new ConcurrentHashMap<PortletKey, PortletStatus>();

    public PortletStatusContainer clone() {
        PortletStatusContainer clone = new PortletStatusContainer();
        for (Map.Entry<PortletKey, PortletStatus> entry : this.map.entrySet()) {
            if (entry.getValue() == null) continue;
            clone.map.put(entry.getKey(), entry.getValue().clone());
        }
        return clone;
    }

    public PortletStatus getPortletStatus(PortalObjectId pageId, String portletName) {
        PortletKey key = new PortletKey(pageId, portletName);
        return this.map.get(key);
    }

    public void setPortletStatus(PortalObjectId pageId, String portletName, PortletStatus status) {
        PortletKey key = new PortletKey(pageId, portletName);
        if (status == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, status);
        }
    }

    public void resetTaskDependentPortletStatus(PortalObjectId pageId) {
        HashSet<Map.Entry<PortletKey, PortletStatus>> clone = new HashSet<Map.Entry<PortletKey, PortletStatus>>(this.map.entrySet());
        for (Map.Entry entry : clone) {
            if (!pageId.equals((Object)((PortletKey)entry.getKey()).pageId) || ((PortletStatus)entry.getValue()).getTaskId() == null) continue;
            this.map.remove(entry.getKey());
        }
    }

    private class PortletKey {
        private final PortalObjectId pageId;
        private final String portletName;

        private PortletKey(PortalObjectId pageId, String portletName) {
            this.pageId = pageId;
            this.portletName = portletName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pageId == null ? 0 : this.pageId.hashCode());
            result = 31 * result + (this.portletName == null ? 0 : this.portletName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortletKey other = (PortletKey)obj;
            if (this.pageId == null ? other.pageId != null : !this.pageId.equals((Object)other.pageId)) {
                return false;
            }
            return !(this.portletName == null ? other.portletName != null : !this.portletName.equals(other.portletName));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PortletKey [pageId=");
            builder.append(this.pageId);
            builder.append(", portletName=");
            builder.append(this.portletName);
            builder.append("]");
            return builder.toString();
        }
    }
}

