/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHLiteral
extends SimpleNode {
    public Object value;

    BSHLiteral(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.value == null) {
            throw new InterpreterError("Null in bsh literal: " + this.value);
        }
        return this.value;
    }

    private char getEscapeChar(char c) {
        switch (c) {
            case 'b': {
                c = (char)8;
                break;
            }
            case 't': {
                c = (char)9;
                break;
            }
            case 'n': {
                c = (char)10;
                break;
            }
            case 'f': {
                c = (char)12;
                break;
            }
            case 'r': {
                c = (char)13;
                break;
            }
        }
        return c;
    }

    public void charSetup(String string) {
        char c = string.charAt(0);
        if (c == '\\') {
            c = string.charAt(1);
            c = Character.isDigit(c) ? (char)Integer.parseInt(string.substring(1), 8) : this.getEscapeChar(c);
        }
        this.value = new Primitive(new Character(c));
    }

    void stringSetup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (Character.isDigit(c = string.charAt(++i))) {
                    int n;
                    for (n = i; n < i + 2 && Character.isDigit(string.charAt(n + 1)); ++n) {
                    }
                    c = (char)Integer.parseInt(string.substring(i, n + 1), 8);
                    i = n;
                } else {
                    c = this.getEscapeChar(c);
                }
            }
            stringBuffer.append(c);
        }
        this.value = stringBuffer.toString();
    }
}

