/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.portlet.MimeResponse;
import javax.portlet.PortletURL;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;

public class CommentsTag
extends ToutaticeSimpleTag {
    private final IBundleFactory bundleFactory;
    private final PersonService personService;

    public CommentsTag() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    }

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        if (document.isCommentable()) {
            Bundle bundle = this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale());
            Element container = this.generateContainer(nuxeoController, document, bundle);
            Element fancybox = this.generateDeleteConfirmationFancybox(nuxeoController, document, bundle);
            HTMLWriter htmlWriter = new HTMLWriter((Writer)this.getJspContext().getOut());
            htmlWriter.setEscapeText(false);
            htmlWriter.write(container);
            htmlWriter.write(fancybox);
        }
    }

    private Element generateContainer(NuxeoController nuxeoController, DocumentDTO document, Bundle bundle) throws JspException {
        MimeResponse response = (MimeResponse)nuxeoController.getResponse();
        String namespace = nuxeoController.getResponse().getNamespace();
        PortletURL addActionUrl = response.createActionURL();
        addActionUrl.setParameter("javax.portlet.action", "addComment");
        String addUrl = addActionUrl.toString();
        Element container = DOM4JUtils.generateDivElement((String)"hidden-print");
        Element commentsContainer = DOM4JUtils.generateDivElement((String)"comments");
        container.add(commentsContainer);
        Element panel = DOM4JUtils.generateDivElement((String)"panel panel-default");
        commentsContainer.add(panel);
        Element panelHeading = DOM4JUtils.generateDivElement((String)"panel-heading");
        panel.add(panelHeading);
        Element panelTitle = DOM4JUtils.generateElement((String)"h3", (String)"panel-title", (String)bundle.getString("COMMENTS"), (String)"glyphicons glyphicons-conversation", null);
        panelHeading.add(panelTitle);
        Element listGroup = DOM4JUtils.generateDivElement((String)"list-group");
        panel.add(listGroup);
        for (CommentDTO comment : document.getComments()) {
            Element listGroupItem = DOM4JUtils.generateDivElement((String)"list-group-item");
            listGroupItem.add(this.generateComment(nuxeoController, bundle, comment));
            listGroup.add(listGroupItem);
        }
        Element panelBody = DOM4JUtils.generateDivElement((String)"panel-body");
        panel.add(panelBody);
        Element addToggle = DOM4JUtils.generateLinkElement((String)("#" + namespace + "-add-comment"), null, null, (String)"btn btn-default no-ajax-link", (String)bundle.getString("COMMENT_ADD"), (String)"glyphicons glyphicons-chat");
        DOM4JUtils.addDataAttribute((Element)addToggle, (String)"toggle", (String)"collapse");
        panelBody.add(addToggle);
        Element addCollapsed = DOM4JUtils.generateDivElement((String)"collapse");
        DOM4JUtils.addAttribute((Element)addCollapsed, (String)"id", (String)(namespace + "-add-comment"));
        panelBody.add(addCollapsed);
        Element addHr = DOM4JUtils.generateElement((String)"hr", null, null);
        addCollapsed.add(addHr);
        Element addForm = DOM4JUtils.generateElement((String)"form", null, null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)addForm, (String)"action", (String)addUrl);
        DOM4JUtils.addAttribute((Element)addForm, (String)"method", (String)"post");
        addCollapsed.add(addForm);
        Element addContentFormGroup = DOM4JUtils.generateDivElement((String)"form-group");
        addForm.add(addContentFormGroup);
        Element addContentLabel = DOM4JUtils.generateElement((String)"label", (String)"control-label", (String)bundle.getString("COMMENT_CONTENT"));
        DOM4JUtils.addAttribute((Element)addContentLabel, (String)"for", (String)(namespace + "-comment-content"));
        addContentFormGroup.add(addContentLabel);
        Element addContentTextarea = DOM4JUtils.generateElement((String)"textarea", (String)"form-control", (String)"");
        DOM4JUtils.addAttribute((Element)addContentTextarea, (String)"id", (String)(namespace + "-comment-content"));
        DOM4JUtils.addAttribute((Element)addContentTextarea, (String)"name", (String)"content");
        addContentFormGroup.add(addContentTextarea);
        Element addButtonsFormGroup = DOM4JUtils.generateDivElement((String)"form-group");
        addForm.add(addButtonsFormGroup);
        Element addSubmit = DOM4JUtils.generateElement((String)"button", (String)"btn btn-primary", (String)bundle.getString("SAVE"));
        DOM4JUtils.addAttribute((Element)addSubmit, (String)"type", (String)"submit");
        addButtonsFormGroup.add(addSubmit);
        Element addCancel = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("CANCEL"));
        DOM4JUtils.addAttribute((Element)addCancel, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)addCancel, (String)"onclick", (String)("$JQry('#" + namespace + "-add-comment').collapse('hide')"));
        addButtonsFormGroup.add(addCancel);
        return container;
    }

    private Element generateDeleteConfirmationFancybox(NuxeoController nuxeoController, DocumentDTO document, Bundle bundle) throws JspException {
        MimeResponse response = (MimeResponse)nuxeoController.getResponse();
        String namespace = response.getNamespace();
        PortletURL actionUrl = response.createActionURL();
        actionUrl.setParameter("javax.portlet.action", "deleteComment");
        String url = actionUrl.toString();
        Element container = DOM4JUtils.generateDivElement((String)"d-none");
        Element fancyboxContainer = DOM4JUtils.generateDivElement((String)"container-fluid");
        DOM4JUtils.addAttribute((Element)fancyboxContainer, (String)"id", (String)(namespace + "-delete-comment"));
        container.add(fancyboxContainer);
        Element form = DOM4JUtils.generateElement((String)"form", null, null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)form, (String)"action", (String)url);
        DOM4JUtils.addAttribute((Element)form, (String)"method", (String)"post");
        fancyboxContainer.add(form);
        Element hidden = DOM4JUtils.generateElement((String)"input", null, null);
        DOM4JUtils.addAttribute((Element)hidden, (String)"type", (String)"hidden");
        DOM4JUtils.addAttribute((Element)hidden, (String)"name", (String)"id");
        form.add(hidden);
        Element formGroup = DOM4JUtils.generateDivElement((String)"form-group");
        form.add(formGroup);
        Element message = DOM4JUtils.generateElement((String)"p", (String)"text-center", (String)bundle.getString("COMMENT_SUPPRESSION_CONFIRM_MESSAGE"));
        formGroup.add(message);
        Element buttonsContainer = DOM4JUtils.generateDivElement((String)"text-center");
        formGroup.add(buttonsContainer);
        Element submit = DOM4JUtils.generateElement((String)"button", (String)"btn btn-warning", (String)bundle.getString("YES"), (String)"glyphicons glyphicons-basic-triangle-alert", null);
        DOM4JUtils.addAttribute((Element)submit, (String)"type", (String)"submit");
        buttonsContainer.add(submit);
        Element cancel = DOM4JUtils.generateElement((String)"button", (String)"btn btn-outline-secondary", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancel, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancel, (String)"onclick", (String)"closeFancybox()");
        buttonsContainer.add(cancel);
        return container;
    }

    private Element generateComment(NuxeoController nuxeoController, Bundle bundle, CommentDTO comment) throws JspException {
        Element container = DOM4JUtils.generateDivElement((String)"comment");
        Element header = this.generateHeader(nuxeoController, bundle, comment);
        container.add(header);
        Element content = DOM4JUtils.generateElement((String)"div", null, (String)comment.getContent());
        container.add(content);
        Element children = this.generateChildren(nuxeoController, bundle, comment);
        container.add(children);
        return container;
    }

    private Element generateHeader(NuxeoController nuxeoController, Bundle bundle, CommentDTO comment) throws JspException {
        Element header = DOM4JUtils.generateDivElement((String)"clearfix");
        Element informations = this.generateInformations(nuxeoController, bundle, comment);
        header.add(informations);
        Element actions = this.generateActions(nuxeoController, bundle, comment);
        header.add(actions);
        return header;
    }

    private Element generateInformations(NuxeoController nuxeoController, Bundle bundle, CommentDTO comment) throws JspException {
        Element container = DOM4JUtils.generateDivElement((String)"pull-left");
        Element paragraph = DOM4JUtils.generateElement((String)"p", (String)"small", null);
        container.add(paragraph);
        Element author = this.generateAuthor(nuxeoController, comment.getAuthor());
        paragraph.add(author);
        Element separator = DOM4JUtils.generateElement((String)"span", null, (String)"&ndash;");
        paragraph.add(separator);
        Element date = this.generateDate(bundle.getLocale(), comment.getCreationDate());
        paragraph.add(date);
        return container;
    }

    private Element generateAuthor(NuxeoController nuxeoController, String author) throws JspException {
        Element container = DOM4JUtils.generateElement((String)"span", null, null);
        try {
            Link avatarLink = nuxeoController.getUserAvatar(author);
            Person person = this.personService.getPerson(author);
            String displayName = person == null ? author : StringUtils.defaultIfEmpty((String)person.getDisplayName(), (String)author);
            Link profileLink = person == null ? null : this.getTagService().getUserProfileLink(nuxeoController, author, displayName);
            if (avatarLink != null) {
                Element avatar = DOM4JUtils.generateElement((String)"img", (String)"avatar", null);
                DOM4JUtils.addAttribute((Element)avatar, (String)"src", (String)avatarLink.getUrl());
                DOM4JUtils.addAttribute((Element)avatar, (String)"alt", (String)"");
                container.add(avatar);
            }
            Element name = profileLink != null ? DOM4JUtils.generateLinkElement((String)profileLink.getUrl(), null, null, null, (String)displayName) : DOM4JUtils.generateElement((String)"span", null, (String)displayName);
            container.add(name);
        }
        catch (CMSException e) {
            throw new JspException((Throwable)e);
        }
        return container;
    }

    private Element generateDate(Locale locale, Date date) {
        DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(0, 3, locale);
        return DOM4JUtils.generateElement((String)"span", null, (String)dateFormat.format(date));
    }

    private Element generateActions(NuxeoController nuxeoController, Bundle bundle, CommentDTO comment) {
        String namespace = nuxeoController.getResponse().getNamespace();
        Element container = DOM4JUtils.generateDivElement((String)"pull-right");
        Element group = DOM4JUtils.generateDivElement((String)"btn-group btn-group-sm");
        container.add(group);
        StringBuilder replyUrlBuilder = new StringBuilder();
        replyUrlBuilder.append("#");
        replyUrlBuilder.append(namespace);
        replyUrlBuilder.append("-reply-comment-");
        replyUrlBuilder.append(comment.getId());
        Element reply = DOM4JUtils.generateLinkElement((String)replyUrlBuilder.toString(), null, null, (String)"btn btn-default no-ajax-link", (String)bundle.getString("REPLY"), (String)"glyphicons glyphicons-chat");
        DOM4JUtils.addDataAttribute((Element)reply, (String)"toggle", (String)"collapse");
        group.add(reply);
        if (comment.isDeletable()) {
            StringBuilder deleteUrlBuilder = new StringBuilder();
            deleteUrlBuilder.append("#");
            deleteUrlBuilder.append(namespace);
            deleteUrlBuilder.append("-delete-comment");
            Element delete = DOM4JUtils.generateLinkElement((String)"javascript:;", null, null, (String)"btn btn-default", (String)bundle.getString("DELETE"), (String)"halflings halflings-trash");
            DOM4JUtils.addDataAttribute((Element)delete, (String)"fancybox", (String)"");
            DOM4JUtils.addDataAttribute((Element)delete, (String)"src", (String)deleteUrlBuilder.toString());
            DOM4JUtils.addDataAttribute((Element)delete, (String)"input-name", (String)"id");
            DOM4JUtils.addDataAttribute((Element)delete, (String)"input-value", (String)comment.getId());
            group.add(delete);
        }
        return container;
    }

    private Element generateChildren(NuxeoController nuxeoController, Bundle bundle, CommentDTO comment) throws JspException {
        Element container = DOM4JUtils.generateDivElement((String)"children");
        Element ul = DOM4JUtils.generateElement((String)"ul", null, null);
        container.add(ul);
        for (CommentDTO child : comment.getChildren()) {
            Element li = DOM4JUtils.generateElement((String)"li", null, null);
            ul.add(li);
            Element hr = DOM4JUtils.generateElement((String)"hr", null, null);
            li.add(hr);
            Element element = this.generateComment(nuxeoController, bundle, child);
            li.add(element);
        }
        Element replyForm = this.generateReplyForm(nuxeoController, bundle, comment);
        ul.add(replyForm);
        return container;
    }

    private Element generateReplyForm(NuxeoController nuxeoController, Bundle bundle, CommentDTO comment) {
        MimeResponse response = (MimeResponse)nuxeoController.getResponse();
        String namespace = response.getNamespace();
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(namespace);
        idBuilder.append("-reply-comment-");
        idBuilder.append(comment.getId());
        Element container = DOM4JUtils.generateElement((String)"li", (String)"collapse", null);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)idBuilder.toString());
        Element hr = DOM4JUtils.generateElement((String)"hr", null, null);
        container.add(hr);
        PortletURL actionUrl = response.createActionURL();
        actionUrl.setParameter("javax.portlet.action", "replyComment");
        actionUrl.setParameter("id", comment.getId());
        Element form = DOM4JUtils.generateElement((String)"form", null, null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)form, (String)"action", (String)actionUrl.toString());
        DOM4JUtils.addAttribute((Element)form, (String)"method", (String)"post");
        container.add(form);
        Element group1 = DOM4JUtils.generateDivElement((String)"form-group");
        form.add(group1);
        String labelTarget = namespace + "-comment-content";
        Element label = DOM4JUtils.generateElement((String)"label", null, (String)bundle.getString("COMMENT_CONTENT"));
        DOM4JUtils.addAttribute((Element)label, (String)"for", (String)labelTarget);
        group1.add(label);
        Element textarea = DOM4JUtils.generateElement((String)"textarea", (String)"form-control", (String)"");
        DOM4JUtils.addAttribute((Element)textarea, (String)"id", (String)labelTarget);
        DOM4JUtils.addAttribute((Element)textarea, (String)"name", (String)"content");
        group1.add(textarea);
        Element group2 = DOM4JUtils.generateDivElement((String)"form-group");
        form.add(group2);
        Element submitButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-primary", (String)bundle.getString("SAVE"));
        DOM4JUtils.addAttribute((Element)submitButton, (String)"type", (String)"submit");
        group2.add(submitButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("CANCEL"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"$JQry(this).closest('.collapse').collapse('hide')");
        group2.add(cancelButton);
        return container;
    }
}

