/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;

public class IncludeTag
extends ToutaticeSimpleTag {
    private String page;

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        String path;
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest servletRequest = pageContext.getRequest();
        PortletRequest portletRequest = nuxeoController.getRequest();
        if (!this.page.startsWith("/")) {
            String servletPath = (String)servletRequest.getAttribute("javax.servlet.include.servlet_path");
            String parentPath = StringUtils.substringBeforeLast((String)servletPath, (String)"/");
            path = parentPath + "/" + this.page;
        } else {
            path = this.page;
        }
        try {
            CustomizedJsp customizedPage = this.getTagService().getCustomizedJsp(nuxeoController, path);
            ClassLoader customizedClassLoader = customizedPage.getClassLoader();
            if (customizedClassLoader != null) {
                portletRequest.setAttribute("osivia.customizer.cms.jsp.classloader", (Object)customizedClassLoader);
            }
            pageContext.include(customizedPage.getName());
        }
        catch (ServletException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            portletRequest.removeAttribute("osivia.customizer.cms.jsp.classloader");
        }
    }

    public void setPage(String page) {
        this.page = page;
    }
}

