/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.ajax;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.handler.AjaxResponse;
import org.jboss.portal.core.controller.handler.CommandForward;
import org.jboss.portal.core.controller.handler.HandlerResponse;
import org.jboss.portal.core.controller.handler.ResponseHandler;
import org.jboss.portal.core.controller.handler.ResponseHandlerException;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowRenderCommand;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.model.portal.command.render.RenderWindowCommand;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.command.response.PortletWindowActionResponse;
import org.jboss.portal.core.model.portal.command.response.UpdatePageResponse;
import org.jboss.portal.core.model.portal.command.view.ViewPageCommand;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateChange;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.core.navstate.NavigationalStateObjectChange;
import org.jboss.portal.core.theme.WindowContextFactory;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PageService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.impl.render.dynamic.DynaResponse;
import org.jboss.portal.theme.impl.render.dynamic.response.UpdatePageLocationResponse;
import org.jboss.portal.theme.impl.render.dynamic.response.UpdatePageStateResponse;
import org.jboss.portal.theme.page.PageResult;
import org.jboss.portal.theme.page.Region;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.ThemeContext;
import org.jboss.portal.web.ServletContextDispatcher;

public class AjaxResponseHandler
implements ResponseHandler {
    private static final Logger log = Logger.getLogger(AjaxResponseHandler.class);
    private PortalObjectContainer portalObjectContainer;
    private PageService pageService;

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public PageService getPageService() {
        return this.pageService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public HandlerResponse processCommandResponse(ControllerContext controllerContext, ControllerCommand commeand, ControllerResponse controllerResponse) throws ResponseHandlerException {
        if (controllerResponse instanceof PortletWindowActionResponse) {
            PortletWindowActionResponse pwr = (PortletWindowActionResponse)controllerResponse;
            StateString contentState = pwr.getContentState();
            WindowState windowState = pwr.getWindowState();
            Mode mode = pwr.getMode();
            InvokePortletWindowRenderCommand renderCmd = new InvokePortletWindowRenderCommand(pwr.getWindowId(), mode, windowState, contentState);
            if (renderCmd != null) {
                return new CommandForward(renderCmd, null);
            }
            return null;
        }
        if (controllerResponse instanceof UpdatePageResponse) {
            UpdatePageResponse upw = (UpdatePageResponse)controllerResponse;
            Page page = (Page)this.portalObjectContainer.getObject(upw.getPageId());
            NavigationalStateContext ctx = (NavigationalStateContext)controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
            HashSet<Object> dirtyWindowIds = new HashSet<Object>();
            boolean fullRefresh = false;
            HashMap<String, String[]> parameters = null;
            if (ctx.getChanges() == null) {
                fullRefresh = true;
            } else {
                Iterator<? extends NavigationalStateChange> i = ctx.getChanges();
                while (i.hasNext()) {
                    Map<QName, String[]> qNameMap;
                    NavigationalStateChange change = i.next();
                    if (!(change instanceof NavigationalStateObjectChange)) {
                        fullRefresh = true;
                        break;
                    }
                    NavigationalStateObjectChange navigationalStateObjectChange = (NavigationalStateObjectChange)change;
                    NavigationalStateKey key = navigationalStateObjectChange.getKey();
                    Class type = key.getType();
                    if (type == WindowNavigationalState.class) {
                        WindowState newWindowState;
                        WindowNavigationalState oldNS = (WindowNavigationalState)navigationalStateObjectChange.getOldValue();
                        WindowState oldWindowState = oldNS != null ? oldNS.getWindowState() : null;
                        WindowNavigationalState newNS = (WindowNavigationalState)navigationalStateObjectChange.getNewValue();
                        WindowState windowState = newWindowState = newNS != null ? newNS.getWindowState() : null;
                        if (WindowState.MAXIMIZED.equals((Object)oldWindowState)) {
                            if (!WindowState.MAXIMIZED.equals((Object)newWindowState)) {
                                fullRefresh = true;
                                break;
                            }
                        } else if (WindowState.MAXIMIZED.equals((Object)newWindowState)) {
                            fullRefresh = true;
                            break;
                        }
                        dirtyWindowIds.add(key.getId());
                        continue;
                    }
                    if (type != PageNavigationalState.class) continue;
                    fullRefresh = true;
                    PageNavigationalState pns = (PageNavigationalState)navigationalStateObjectChange.getNewValue();
                    if (pns == null || (qNameMap = pns.getParameters()) == null || qNameMap.isEmpty()) continue;
                    parameters = new HashMap<String, String[]>(qNameMap.size());
                    for (Map.Entry<QName, String[]> entry : qNameMap.entrySet()) {
                        parameters.put(entry.getKey().toString(), entry.getValue());
                    }
                }
            }
            ctx.applyChanges();
            if (!fullRefresh) {
                ArrayList<Window> refreshedWindows = new ArrayList<Window>();
                for (Object e : dirtyWindowIds) {
                    PortalObjectId poid = (PortalObjectId)e;
                    String windowName = poid.getPath().getLastComponentName();
                    Window child = page.getChild(windowName, Window.class);
                    if (child == null) continue;
                    refreshedWindows.add(child);
                }
                LayoutService layoutService = this.getPageService().getLayoutService();
                PortalLayout portalLayout = RenderPageCommand.getLayout(layoutService, page);
                UpdatePageStateResponse updatePage = new UpdatePageStateResponse(ctx.getViewId());
                PageResult res = new PageResult(page.getName(), page.getProperties());
                ServerInvocation invocation = controllerContext.getServerInvocation();
                WindowContextFactory wcf = new WindowContextFactory(controllerContext);
                ControllerPortletControllerContext portletControllerContext = new ControllerPortletControllerContext(controllerContext, page);
                ControllerPageNavigationalState pageNavigationalState = portletControllerContext.getStateControllerContext().createPortletPageNavigationalState(true);
                Iterator i = refreshedWindows.iterator();
                while (i.hasNext() && !fullRefresh) {
                    try {
                        Window refreshedWindow = (Window)i.next();
                        RenderWindowCommand rwc = new RenderWindowCommand(pageNavigationalState, refreshedWindow.getId());
                        WindowRendition rendition = rwc.render(controllerContext);
                        if (rendition != null) {
                            ControllerResponse resp = rendition.getControllerResponse();
                            if (resp instanceof MarkupResponse) {
                                WindowContext wc = wcf.createWindowContext(refreshedWindow, rendition);
                                res.addWindowContext(wc);
                                MarkupInfo markupInfo = (MarkupInfo)invocation.getResponse().getContentInfo();
                                StringWriter buffer = new StringWriter();
                                ServletContextDispatcher dispatcher = new ServletContextDispatcher(invocation.getServerContext().getClientRequest(), invocation.getServerContext().getClientResponse(), controllerContext.getServletContainer());
                                ThemeContext themeContext = new ThemeContext(null, null);
                                RendererContext rendererContext = portalLayout.getRenderContext(themeContext, markupInfo, dispatcher, (Writer)buffer);
                                rendererContext.pushObjectRenderContext((ObjectRendererContext)res);
                                Region region = res.getRegion2(wc.getRegionName());
                                rendererContext.pushObjectRenderContext((ObjectRendererContext)region);
                                rendererContext.render((ObjectRendererContext)wc);
                                rendererContext.popObjectRenderContext();
                                rendererContext.popObjectRenderContext();
                                updatePage.addFragment(wc.getId(), buffer.toString());
                                continue;
                            }
                            fullRefresh = true;
                            continue;
                        }
                        fullRefresh = true;
                    }
                    catch (Exception e) {
                        log.error((Object)"An error occured during the computation of window markup", (Throwable)e);
                        fullRefresh = true;
                    }
                }
                if (!fullRefresh) {
                    return new AjaxResponse((DynaResponse)updatePage);
                }
            }
            ViewPageCommand rpc = parameters == null ? new ViewPageCommand(page.getId()) : new ViewPageCommand(page.getId(), parameters);
            String url = controllerContext.renderURL(rpc, null, null);
            UpdatePageLocationResponse updatePageLocationResponse = new UpdatePageLocationResponse(url);
            return new AjaxResponse((DynaResponse)updatePageLocationResponse);
        }
        return null;
    }
}

