/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.mail;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.io.PrintStream;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.jboss.logging.util.LoggerStream;
import org.jboss.portal.core.modules.AbstractModule;
import org.jboss.portal.core.modules.MailModule;

public class MailModuleImpl
extends AbstractModule
implements MailModule {
    private final Logger log = Logger.getLogger(this.getClass());
    private Properties properties = new Properties();
    private int queueCapacity = -1;
    private QueuedExecutor executor;
    private Channel queue;
    public String gateway;
    private String smtpUser;
    private String smtpPassword;
    private MailAuthenticator smtpAuth;
    private boolean javaMailDebugEnabled = false;
    private int SMTPConnectionTimeout = 10000;
    private int SMTPTimeout = 10000;
    private LoggerStream logs;
    private final SynchronizedLong currentSerialId = new SynchronizedLong(0L);
    public static final String DEFAULT_CONTENT_MIME_TYPE = "text/plain";

    public int getSMTPConnectionTimeout() {
        return this.SMTPConnectionTimeout;
    }

    public void setSMTPConnectionTimeout(int SMTPConnectionTimeout) {
        this.SMTPConnectionTimeout = SMTPConnectionTimeout;
    }

    public int getSMTPTimeout() {
        return this.SMTPTimeout;
    }

    public void setSMTPTimeout(int SMTPTimeout) {
        this.SMTPTimeout = SMTPTimeout;
    }

    public long getCurrentSerialId() {
        return this.currentSerialId.get();
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public int getQueueSize() {
        if (this.queue == null) {
            return -1;
        }
        if (this.queue instanceof BoundedLinkedQueue) {
            return ((BoundedLinkedQueue)this.queue).capacity();
        }
        return 0;
    }

    public String listProperties() {
        StringBuffer buffer = new StringBuffer("[");
        Iterator<Map.Entry<Object, Object>> i = this.properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            buffer.append(entry.getKey()).append("=").append(entry.getValue());
            buffer.append(i.hasNext() ? "," : "]");
        }
        return buffer.toString();
    }

    public int flushQueue() {
        try {
            int size = 0;
            MyMessage r = (MyMessage)this.queue.poll(0L);
            while (r != null) {
                this.log.debug((Object)("Removed serialId=" + r.serialId + " from the queue"));
                ++size;
                r = (MyMessage)this.queue.poll(0L);
            }
            return size;
        }
        catch (InterruptedException ignore) {
            return -1;
        }
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public boolean getJavaMailDebugEnabled() {
        return this.javaMailDebugEnabled;
    }

    public void setJavaMailDebugEnabled(boolean javaMailDebugEnabled) {
        this.javaMailDebugEnabled = javaMailDebugEnabled;
    }

    public void send(String from, String to, String subject, String body, String contentType) {
        try {
            MyMessage runnable = new MyMessage(from, to, subject, body, contentType);
            this.log.debug((Object)("Enqueuing serialId=" + runnable.serialId));
            this.executor.execute((Runnable)runnable);
            this.log.debug((Object)("Enqueued serialId=" + runnable.serialId));
        }
        catch (InterruptedException ignore) {
            this.log.debug((Object)"Interrupted during deliver attempt");
        }
    }

    public void send(String from, String to, String subject, String body) {
        this.send(from, to, subject, body, DEFAULT_CONTENT_MIME_TYPE);
    }

    protected void startService() throws Exception {
        this.queue = this.queueCapacity > 0 ? new BoundedLinkedQueue(this.queueCapacity) : new LinkedQueue();
        this.executor = new QueuedExecutor(this.queue);
        if (this.gateway != null && this.gateway.length() > 0) {
            this.properties.setProperty("mail.smtp.host", this.gateway);
        } else {
            this.log.warn((Object)"You did not set up any SMTP gateway, cannot send any email");
        }
        if (this.smtpUser != null) {
            this.properties.setProperty("mail.smtp.auth", "true");
            this.smtpAuth = new MailAuthenticator(this.smtpUser, this.smtpPassword);
        } else {
            this.properties.setProperty("mail.smtp.auth", "false");
            this.smtpAuth = null;
        }
        this.properties.setProperty("mail.smtp.connectiontimeout", "" + this.SMTPConnectionTimeout);
        this.properties.setProperty("mail.smtp.timeout", "" + this.SMTPTimeout);
        super.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        try {
            super.stopService();
        }
        finally {
            this.properties.clear();
            this.executor.shutdownAfterProcessingCurrentTask();
            this.executor = null;
            this.queue = null;
        }
    }

    public boolean deliver(long serialId, String from, String to, String subject, String body) {
        return this.deliver(serialId, from, to, subject, body, DEFAULT_CONTENT_MIME_TYPE);
    }

    public boolean deliver(long serialId, String from, String to, String subject, String body, String contentType) {
        boolean delivered = false;
        try {
            if (this.gateway != null && this.gateway.length() > 0) {
                delivered = this.deliver(serialId, this.gateway, from, to, subject, body, contentType);
            } else {
                this.log.warn((Object)"You did not specify any gateway, the email cannot be sent");
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Problem while delivering serialId=" + serialId), t);
        }
        return delivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(long serialId, String host, String from, String to, String subject, String body, String contentType) throws AddressException, NoSuchProviderException, MessagingException {
        Transport transport = null;
        try {
            InternetAddress toAddress = new InternetAddress(to);
            Session session = Session.getDefaultInstance((Properties)this.properties, (Authenticator)this.smtpAuth);
            session.setDebug(this.javaMailDebugEnabled);
            session.setDebugOut((PrintStream)this.logs);
            URLName urlname = new URLName("smtp://" + host);
            transport = session.getTransport(urlname);
            this.log.debug((Object)("Connecting to " + host + " with serialId=" + serialId));
            transport.connect();
            this.log.debug((Object)("Connected to " + host + " with serialId=" + serialId));
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.setContent((Object)body, contentType);
            message.setSubject(subject);
            message.setSentDate(new Date());
            message.addRecipient(Message.RecipientType.TO, (Address)toAddress);
            this.log.debug((Object)("Sending message serialId=" + serialId));
            transport.sendMessage((Message)message, (Address[])new InternetAddress[]{toAddress});
            this.log.debug((Object)("Sent msg, subject=" + subject + ", serialId=" + serialId));
            boolean bl = true;
            return bl;
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException ignore) {}
            }
        }
    }

    private class MyMessage
    implements Runnable {
        public final long serialId;
        public final String from;
        public final String to;
        public final String subject;
        public final String body;
        public final String contentType;

        public MyMessage(String from, String to, String subject, String body, String contentType) {
            this.serialId = MailModuleImpl.this.currentSerialId.increment();
            this.from = from;
            this.to = to;
            this.subject = subject;
            this.body = body;
            this.contentType = contentType;
        }

        public void run() {
            try {
                MailModuleImpl.this.log.debug((Object)("Dequeued serialId=" + this.serialId + " and delivering it"));
                boolean delivered = MailModuleImpl.this.deliver(this.serialId, this.from, this.to, this.subject, this.body, this.contentType);
                MailModuleImpl.this.log.debug((Object)(delivered + " on delivery for serialId=" + this.serialId));
            }
            catch (Throwable t) {
                MailModuleImpl.this.log.error((Object)("Caught throwable while delivering serialId=" + this.serialId), t);
            }
        }
    }

    private static class MailAuthenticator
    extends Authenticator {
        private String username = null;
        private String password = null;

        public MailAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

