/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dom4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jaxen.VariableContext;
import org.jboss.dom4j.Attribute;
import org.jboss.dom4j.CDATA;
import org.jboss.dom4j.Comment;
import org.jboss.dom4j.Document;
import org.jboss.dom4j.DocumentType;
import org.jboss.dom4j.Element;
import org.jboss.dom4j.Entity;
import org.jboss.dom4j.InvalidXPathException;
import org.jboss.dom4j.Namespace;
import org.jboss.dom4j.NodeFilter;
import org.jboss.dom4j.ProcessingInstruction;
import org.jboss.dom4j.QName;
import org.jboss.dom4j.Text;
import org.jboss.dom4j.XPath;
import org.jboss.dom4j.rule.Pattern;
import org.jboss.dom4j.tree.AbstractDocument;
import org.jboss.dom4j.tree.DefaultAttribute;
import org.jboss.dom4j.tree.DefaultCDATA;
import org.jboss.dom4j.tree.DefaultComment;
import org.jboss.dom4j.tree.DefaultDocument;
import org.jboss.dom4j.tree.DefaultDocumentType;
import org.jboss.dom4j.tree.DefaultElement;
import org.jboss.dom4j.tree.DefaultEntity;
import org.jboss.dom4j.tree.DefaultProcessingInstruction;
import org.jboss.dom4j.tree.DefaultText;
import org.jboss.dom4j.tree.QNameCache;
import org.jboss.dom4j.util.SimpleSingleton;
import org.jboss.dom4j.util.SingletonStrategy;
import org.jboss.dom4j.xpath.DefaultXPath;
import org.jboss.dom4j.xpath.XPathPattern;

public class DocumentFactory
implements Serializable {
    private static SingletonStrategy singleton = null;
    protected transient QNameCache cache;
    private Map xpathNamespaceURIs;
    static /* synthetic */ Class class$org$dom4j$DocumentFactory;

    private static SingletonStrategy createSingleton() {
        String documentFactoryClassName;
        SingletonStrategy result = null;
        try {
            documentFactoryClassName = System.getProperty("org.jboss.dom4j.factory", "org.jboss.dom4j.DocumentFactory");
        }
        catch (Exception e) {
            documentFactoryClassName = "org.jboss.dom4j.DocumentFactory";
        }
        try {
            String singletonClass = System.getProperty("org.jboss.dom4j.DocumentFactory.singleton.strategy", "org.jboss.dom4j.util.SimpleSingleton");
            Class<?> clazz = Class.forName(singletonClass);
            result = (SingletonStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            result = new SimpleSingleton();
        }
        result.setSingletonClassName(documentFactoryClassName);
        return result;
    }

    public DocumentFactory() {
        this.init();
    }

    public static synchronized DocumentFactory getInstance() {
        if (singleton == null) {
            singleton = DocumentFactory.createSingleton();
        }
        return (DocumentFactory)singleton.instance();
    }

    public Document createDocument() {
        DefaultDocument answer = new DefaultDocument();
        answer.setDocumentFactory(this);
        return answer;
    }

    public Document createDocument(String encoding) {
        Document answer = this.createDocument();
        if (answer instanceof AbstractDocument) {
            ((AbstractDocument)answer).setXMLEncoding(encoding);
        }
        return answer;
    }

    public Document createDocument(Element rootElement) {
        Document answer = this.createDocument();
        answer.setRootElement(rootElement);
        return answer;
    }

    public DocumentType createDocType(String name, String publicId, String systemId) {
        return new DefaultDocumentType(name, publicId, systemId);
    }

    public Element createElement(QName qname) {
        return new DefaultElement(qname);
    }

    public Element createElement(String name) {
        return this.createElement(this.createQName(name));
    }

    public Element createElement(String qualifiedName, String namespaceURI) {
        return this.createElement(this.createQName(qualifiedName, namespaceURI));
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        return new DefaultAttribute(qname, value);
    }

    public Attribute createAttribute(Element owner, String name, String value) {
        return this.createAttribute(owner, this.createQName(name), value);
    }

    public CDATA createCDATA(String text) {
        return new DefaultCDATA(text);
    }

    public Comment createComment(String text) {
        return new DefaultComment(text);
    }

    public Text createText(String text) {
        if (text == null) {
            String msg = "Adding text to an XML document must not be null";
            throw new IllegalArgumentException(msg);
        }
        return new DefaultText(text);
    }

    public Entity createEntity(String name, String text) {
        return new DefaultEntity(name, text);
    }

    public Namespace createNamespace(String prefix, String uri) {
        return Namespace.get(prefix, uri);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public QName createQName(String localName, Namespace namespace) {
        return this.cache.get(localName, namespace);
    }

    public QName createQName(String localName) {
        return this.cache.get(localName);
    }

    public QName createQName(String name, String prefix, String uri) {
        return this.cache.get(name, Namespace.get(prefix, uri));
    }

    public QName createQName(String qualifiedName, String uri) {
        return this.cache.get(qualifiedName, uri);
    }

    public XPath createXPath(String xpathExpression) throws InvalidXPathException {
        DefaultXPath xpath = new DefaultXPath(xpathExpression);
        if (this.xpathNamespaceURIs != null) {
            xpath.setNamespaceURIs(this.xpathNamespaceURIs);
        }
        return xpath;
    }

    public XPath createXPath(String xpathExpression, VariableContext variableContext) {
        XPath xpath = this.createXPath(xpathExpression);
        xpath.setVariableContext(variableContext);
        return xpath;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression, VariableContext variableContext) {
        XPath answer = this.createXPath(xpathFilterExpression);
        answer.setVariableContext(variableContext);
        return answer;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression) {
        return this.createXPath(xpathFilterExpression);
    }

    public Pattern createPattern(String xpathPattern) {
        return new XPathPattern(xpathPattern);
    }

    public List getQNames() {
        return this.cache.getQNames();
    }

    public Map getXPathNamespaceURIs() {
        return this.xpathNamespaceURIs;
    }

    public void setXPathNamespaceURIs(Map namespaceURIs) {
        this.xpathNamespaceURIs = namespaceURIs;
    }

    protected static DocumentFactory createSingleton(String className) {
        try {
            Class<?> theClass = Class.forName(className, true, (class$org$dom4j$DocumentFactory == null ? (class$org$dom4j$DocumentFactory = DocumentFactory.class$("org.jboss.dom4j.DocumentFactory")) : class$org$dom4j$DocumentFactory).getClassLoader());
            return (DocumentFactory)theClass.newInstance();
        }
        catch (Throwable e) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + className);
            return new DocumentFactory();
        }
    }

    protected QName intern(QName qname) {
        return this.cache.intern(qname);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

