/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.gandiva.inventory;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.gandiva.inventory.InventoryElement;
import com.arjuna.ats.arjuna.gandiva.inventory.InventoryImple;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.Implementations;
import com.arjuna.ats.internal.arjuna.gandiva.inventory.InventoryList;
import java.io.PrintStream;
import java.util.Enumeration;

public class StaticInventory
extends InventoryImple {
    private static InventoryList headOfList = null;
    private static boolean initialised = false;

    public synchronized Object createVoid(ClassName typeName) {
        InventoryElement creator = this.find(typeName);
        if (creator != null) {
            return creator.createVoid();
        }
        return null;
    }

    public synchronized Object createClassName(ClassName typeName, ClassName paramClassName) {
        InventoryElement creator = this.find(typeName);
        if (creator != null) {
            return creator.createClassName(paramClassName);
        }
        return null;
    }

    public synchronized Object createObjectName(ClassName typeName, ObjectName paramObjectName) {
        InventoryElement creator = this.find(typeName);
        if (creator != null) {
            return creator.createObjectName(paramObjectName);
        }
        return null;
    }

    public synchronized Object createResources(ClassName typeName, Object[] paramResources) {
        InventoryElement creator = this.find(typeName);
        if (creator != null) {
            return creator.createResources(paramResources);
        }
        return null;
    }

    public synchronized Object createClassNameResources(ClassName typeName, ClassName paramClassName, Object[] paramResources) {
        InventoryElement creator = this.find(typeName);
        if (creator != null) {
            return creator.createClassNameResources(paramClassName, paramResources);
        }
        return null;
    }

    public synchronized Object createObjectNameResources(ClassName typeName, ObjectName paramObjectName, Object[] paramResources) {
        InventoryElement creator = this.find(typeName);
        if (creator != null) {
            return creator.createObjectNameResources(paramObjectName, paramResources);
        }
        return null;
    }

    public synchronized void addToList(InventoryElement creator) {
        if (creator != null && creator.className() != null) {
            if (headOfList == null) {
                headOfList = new InventoryList(creator);
            } else {
                boolean found = false;
                InventoryList marker = headOfList;
                InventoryList trail = null;
                while (!found && marker != null) {
                    if (!creator.className().equals(marker._instance.className())) {
                        trail = marker;
                        marker = marker._next;
                        continue;
                    }
                    found = true;
                }
                if (!found) {
                    trail._next = new InventoryList(creator);
                }
            }
        }
    }

    public synchronized void printList(PrintStream toUse) {
        InventoryList marker = headOfList;
        toUse.println("StaticInventory contains:");
        while (marker != null) {
            toUse.println(marker._instance.className());
            marker = marker._next;
        }
        toUse.println("End of list.");
    }

    public ClassName className() {
        return ArjunaNames.Implementation_Inventory_StaticInventory();
    }

    public static ClassName type() {
        return ArjunaNames.Implementation_Inventory_StaticInventory();
    }

    protected InventoryElement find(ClassName className) {
        if (!initialised) {
            this.initialise();
        }
        if (headOfList != null) {
            InventoryList marker = headOfList;
            while (marker != null) {
                if (marker._instance.className() != null && marker._instance.className().equals(className)) {
                    return marker._instance;
                }
                marker = marker._next;
            }
        }
        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.gandiva.inventory.StaticInventory_1", new Object[]{className});
        }
        return null;
    }

    private final synchronized void initialise() {
        Implementations.initialise();
        Enumeration e = arjPropertyManager.propertyManager.propertyNames();
        if (e != null) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith("com.arjuna.ats.internal.arjuna.inventory.staticInventoryImple")) continue;
                String className = arjPropertyManager.propertyManager.getProperty(name);
                try {
                    Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    Object o = c.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        initialised = true;
    }
}

