/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.apache.log4j.Logger;
import org.jboss.portal.server.deployment.CannotCreatePortletWebAppException;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.PortalWebTomcat4App;
import org.jboss.portal.server.deployment.PortalWebTomcat5App;
import org.jboss.portal.server.deployment.PortalWebTomcat6App;
import org.jboss.web.WebApplication;
import org.xml.sax.EntityResolver;

public class PortalWebAppFactory {
    private static Logger log = Logger.getLogger(PortalWebAppFactory.class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int UNKNOWN = 0;
    private static final int TOMCAT4 = 1;
    private static final int TOMCAT5 = 2;
    private static final int TOMCAT6 = 3;
    private final MBeanServer server;

    public PortalWebAppFactory(MBeanServer server) {
        this.server = server;
    }

    public PortalWebApp create(WebApplication webApp, EntityResolver jbossAppEntityResolver) throws CannotCreatePortletWebAppException {
        int version = PortalWebAppFactory.getVersion();
        switch (version) {
            case 1: {
                return new PortalWebTomcat4App(webApp, jbossAppEntityResolver);
            }
            case 2: {
                return new PortalWebTomcat5App(webApp, this.server, jbossAppEntityResolver);
            }
            case 3: {
                return new PortalWebTomcat6App(webApp, this.server, jbossAppEntityResolver);
            }
        }
        throw new CannotCreatePortletWebAppException("JBossWeb cannot handle it : " + version);
    }

    private static int getVersion() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> serverInfoClass = cl.loadClass("org.apache.catalina.util.ServerInfo");
            Method getServerInfoMethod = serverInfoClass.getMethod("getServerInfo", EMPTY_CLASS_ARRAY);
            String result = (String)getServerInfoMethod.invoke(null, EMPTY_OBJECT_ARRAY);
            if (result != null) {
                if (result.startsWith("Apache Tomcat/6")) {
                    return 3;
                }
                if (result.startsWith("Apache Tomcat/5")) {
                    return 2;
                }
                if (result.startsWith("Apache Tomcat/4")) {
                    return 1;
                }
                if (result.startsWith("JBoss Web Server/1")) {
                    return 2;
                }
                if (result.startsWith("JBossWeb/2")) {
                    return 3;
                }
                log.error((Object)("Cannot handle tomcat version: " + result));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Cannot getPortalObjectContext catalina ServerInfo class");
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"Cannot invoke ServerInfo.getServerInfo()", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error", (Throwable)e);
        }
        return 0;
    }
}

