/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment.jboss;

import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.portal.common.net.URLFilter;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.server.deployment.jboss.DeploymentFactory;
import org.jboss.portal.server.deployment.jboss.ServerDeployerMBean;

public abstract class AbstractDeploymentFactory
implements DeploymentFactory,
URLFilter {
    protected ServerDeployerMBean deployer = null;
    protected boolean registrationControlledByService = true;
    protected String setupLocation = null;
    protected URL setupURL;
    protected final String name;
    protected final Logger log = Logger.getLogger(this.getClass());

    protected AbstractDeploymentFactory() {
        this.name = Tools.getShortNameOf(this.getClass());
    }

    public String getName() {
        return this.name;
    }

    public boolean acceptDir(URL url) {
        return url.getPath().endsWith("/WEB-INF/");
    }

    public String getSetupLocation() {
        return this.setupLocation;
    }

    public void setSetupLocation(String setupLocation) {
        this.setupLocation = setupLocation;
    }

    public boolean isRegistrationControlledByService() {
        return this.registrationControlledByService;
    }

    public void setRegistrationControlledByService(boolean registrationControlledByService) {
        this.registrationControlledByService = registrationControlledByService;
    }

    public ServerDeployerMBean getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ServerDeployerMBean deployer) {
        this.deployer = deployer;
    }

    public void registerFactory() {
        this.deployer.registerFactory(this.name, this, this, this.setupURL);
    }

    public void unregisterFactory() {
        this.deployer.unregisterFactory(this.name);
    }

    public URL getSetupURL() {
        return this.setupURL;
    }

    public void create() throws Exception {
        if (this.setupLocation != null) {
            this.setupURL = Thread.currentThread().getContextClassLoader().getResource(this.setupLocation);
        }
    }

    public void start() throws Exception {
        if (this.registrationControlledByService) {
            this.registerFactory();
        }
    }

    public void stop() {
        if (this.registrationControlledByService) {
            this.unregisterFactory();
        }
    }

    public void destroy() throws Exception {
        this.setupURL = null;
    }
}

