/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.common.invocation.AbstractInvocationContext;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.text.CharBuffer;
import org.jboss.portal.common.text.CharEncoder;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.server.ServerURL;
import org.jboss.portal.server.impl.SyncRequestAttributeResolver;
import org.jboss.portal.server.impl.invocation.SessionAttributeResolver;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;
import org.jboss.portal.web.Body;
import org.jboss.portal.web.WebRequest;
import org.osivia.portal.core.utils.URLUtils;

public class ServerInvocationContextImpl
extends AbstractInvocationContext
implements ServerInvocationContext {
    private static final FastURLEncoder urlEncoder = FastURLEncoder.getUTF8Instance();
    private final HttpServletRequest req;
    private final WebRequest webReq;
    private final HttpServletResponse resp;
    private String portalContextPath;
    private String portalRequestPath;
    private String portalHost;
    private URLContext urlContext;
    private final String requestRelativePrefix;
    private final String requestPrefix;

    public ServerInvocationContextImpl(HttpServletRequest req, HttpServletResponse resp, WebRequest webReq, String portalHost, String portalRequestPath, String portalContextPath, URLContext urlContext) {
        String url;
        if (req == null) {
            throw new IllegalArgumentException();
        }
        if (resp == null) {
            throw new IllegalArgumentException();
        }
        this.req = req;
        this.webReq = webReq;
        this.resp = resp;
        this.portalRequestPath = portalRequestPath;
        this.portalContextPath = portalContextPath;
        this.portalHost = portalHost;
        this.urlContext = urlContext;
        this.requestRelativePrefix = url = URLUtils.createUrl((HttpServletRequest)req, (String)req.getContextPath(), null);
        this.requestPrefix = req.getContextPath();
        this.addResolver(ServerInvocation.REQUEST_SCOPE, new SyncRequestAttributeResolver(req));
        this.addResolver(ServerInvocation.SESSION_SCOPE, new SessionAttributeResolver(req, "portal.session", false));
        this.addResolver(ServerInvocation.PRINCIPAL_SCOPE, new SessionAttributeResolver(req, "portal.principal", true));
    }

    public WebRequest getWebRequest() {
        return this.webReq;
    }

    @Override
    public HttpServletRequest getClientRequest() {
        return this.req;
    }

    @Override
    public HttpServletResponse getClientResponse() {
        return this.resp;
    }

    @Override
    public String getMediaType() {
        MediaType mediaType = this.webReq.getMediaType();
        if (mediaType == null) {
            return null;
        }
        return mediaType.getValue();
    }

    @Override
    public URLContext getURLContext() {
        return this.urlContext;
    }

    @Override
    public ParameterMap getQueryParameterMap() {
        return ParameterMap.wrap((Map)this.webReq.getQueryParameterMap());
    }

    @Override
    public ParameterMap getBodyParameterMap() {
        Body body = this.webReq.getBody();
        if (body instanceof Body.Form) {
            return ParameterMap.wrap((Map)((Body.Form)body).getParameters());
        }
        return null;
    }

    @Override
    public String getPortalRequestPath() {
        return this.portalRequestPath;
    }

    @Override
    public String getPortalContextPath() {
        return this.portalContextPath;
    }

    @Override
    public String getPortalHost() {
        return this.portalHost;
    }

    @Override
    public String renderURL(ServerURL url, URLContext context, URLFormat format) {
        Buffer buffer = new Buffer(this.resp, context, format);
        return buffer.toString(url);
    }

    public class Buffer
    extends CharBuffer {
        private final HttpServletResponse resp;
        private final URLFormat format;
        private final int prefixLength;

        public Buffer(HttpServletResponse resp, URLContext context, URLFormat format) {
            this.resp = resp;
            this.format = format;
            if (!format.isRelative()) {
                this.append(ServerInvocationContextImpl.this.requestRelativePrefix);
            } else {
                this.append(ServerInvocationContextImpl.this.requestPrefix);
            }
            switch (context.getMask()) {
                case 3: {
                    this.append("/authsec");
                    break;
                }
                case 2: {
                    this.append("/auth");
                    break;
                }
                case 1: {
                    this.append("/sec");
                }
            }
            this.prefixLength = this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString(ServerURL url) {
            this.length = this.prefixLength;
            this.append(url.getPortalRequestPath());
            boolean first = true;
            for (Map.Entry element : url.getParameterMap().entrySet()) {
                String[] values;
                String name = (String)element.getKey();
                for (String value : values = (String[])element.getValue()) {
                    this.append(first ? (char)'?' : '&');
                    this.append(name, (CharEncoder)urlEncoder);
                    this.append('=');
                    this.append(value, (CharEncoder)urlEncoder);
                    first = false;
                }
            }
            String s = this.asString();
            if (this.format.isServletEncoded()) {
                HttpServletResponse httpServletResponse = this.resp;
                synchronized (httpServletResponse) {
                    s = this.resp.encodeURL(s);
                }
            }
            return s;
        }
    }
}

