/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;

public class FormatVocabulary3LevelTag
extends ToutaticeSimpleTag {
    private String vocabulary;
    private String child1;
    private String child2;
    private String xpath;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }

    public void setChild1(String child1) {
        this.child1 = child1;
    }

    public void setChild2(String child2) {
        this.child2 = child2;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    private String formatVocabulary3Level(NuxeoController ctx, Document doc, String vocParent, String vocChild1, String vocChild2, String xpath) throws Exception {
        StringBuffer stb = new StringBuffer();
        String value = doc.getProperties().getString(xpath);
        if (value != null) {
            String[] tab = value.split("/");
            stb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)ctx, (String)vocParent, (String)tab[0]));
            if (tab.length > 1) {
                stb.append(" / ");
                stb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)ctx, (String)vocChild1, (String)tab[1]));
            }
            if (tab.length > 2 && vocChild2 != null) {
                stb.append(" / ");
                stb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)ctx, (String)vocChild2, (String)tab[2]));
            }
        }
        return stb.toString();
    }

    private String formatVocabulary3Level(NuxeoController ctx, String value, String vocParent, String vocChild1, String vocChild2) throws Exception {
        StringBuffer stb = new StringBuffer();
        if (value != null) {
            String[] tab = value.split("/");
            stb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)ctx, (String)vocParent, (String)tab[0]));
            if (tab.length > 1) {
                stb.append(" / ");
                stb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)ctx, (String)vocChild1, (String)tab[1]));
            }
            if (tab.length > 2 && vocChild2 != null) {
                stb.append(" / ");
                stb.append(VocabularyHelper.getVocabularyLabel((NuxeoController)ctx, (String)vocChild2, (String)tab[2]));
            }
        }
        return stb.toString();
    }

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        if (nuxeoController != null && document != null) {
            Document nuxeoDocument = document.getDocument();
            Object obj = nuxeoDocument.getProperties().get(this.xpath);
            String result = "";
            try {
                if (obj instanceof PropertyList) {
                    StringBuilder stb = new StringBuilder();
                    for (int i = 0; i < ((PropertyList)obj).size(); ++i) {
                        stb.append(this.formatVocabulary3Level(nuxeoController, ((PropertyList)obj).getString(i), this.vocabulary, this.child1, this.child2));
                        stb.append("<br/>");
                    }
                    result = stb.toString();
                } else {
                    result = this.formatVocabulary3Level(nuxeoController, nuxeoDocument, this.vocabulary, this.child1, this.child2, this.xpath);
                }
                JspWriter out = pageContext.getOut();
                out.write(result);
            }
            catch (Exception e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

