/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.Locale;
import javax.xml.registry.infomodel.LocalizedString;

public class LocalizedStringImpl
implements LocalizedString {
    private String charsetName;
    private Locale locale;
    private String value;

    public LocalizedStringImpl() {
        this.locale = Locale.getDefault();
        this.charsetName = "UTF-8";
    }

    public LocalizedStringImpl(Locale locale, String value, String charsetName) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.locale = locale;
        this.value = value;
        this.charsetName = charsetName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getValue() {
        return this.value;
    }

    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.charsetName = charsetName;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        this.locale = locale;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalizedStringImpl)) {
            return false;
        }
        LocalizedStringImpl localizedString = (LocalizedStringImpl)o;
        if (!this.charsetName.equals(localizedString.charsetName)) {
            return false;
        }
        if (!this.locale.equals(localizedString.locale)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(localizedString.value) : localizedString.value != null);
    }

    public int hashCode() {
        int result = this.charsetName.hashCode();
        result = 29 * result + this.locale.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.value;
    }
}

