/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.component.portlet;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.StateString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestEncoder {
    private ParameterMap queryParameters;

    public PortletRequestEncoder(ParameterMap queryParameters) {
        if (queryParameters == null) {
            throw new IllegalArgumentException();
        }
        this.queryParameters = queryParameters;
    }

    public PortletRequestEncoder() {
        this(new ParameterMap());
    }

    public void encodeAction(StateString navigationalState, StateString interactionState, Mode mode, WindowState windowState) throws IllegalArgumentException {
        this.queryParameters.clear();
        int meta = 1;
        if (interactionState != null) {
            if (interactionState instanceof ParametersStateString) {
                navigationalState = null;
                Map parameters = ((ParametersStateString)interactionState).getParameters();
                this.configure(parameters);
            } else {
                meta |= 0x10;
                this.queryParameters.setValue("is", interactionState.getStringValue());
                if (navigationalState != null) {
                    this.queryParameters.setValue("ns", navigationalState.getStringValue());
                }
            }
        }
        this.configure(meta, mode, windowState);
    }

    public void encodeRender(StateString navigationalState, Mode mode, WindowState windowState) {
        this.queryParameters.clear();
        if (navigationalState != null) {
            int meta = 2;
            if (navigationalState instanceof ParametersStateString) {
                Map parameters = ((ParametersStateString)navigationalState).getParameters();
                this.configure(parameters);
            } else {
                meta |= 0x10;
                this.queryParameters.setValue("ns", navigationalState.getStringValue());
            }
            this.configure(meta, mode, windowState);
        } else {
            if (mode != null) {
                this.queryParameters.setValue("mode", mode.toString());
            }
            if (windowState != null) {
                this.queryParameters.setValue("windowstate", windowState.toString());
            }
        }
    }

    public ParameterMap getQueryParameters() {
        return this.queryParameters;
    }

    private void configure(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            this.queryParameters.setValues(name, values);
        }
    }

    private void configure(int meta, Mode mode, WindowState windowState) {
        if (mode != null) {
            meta |= 4;
            this.setMetaParameter("mode", mode.toString());
        }
        if (windowState != null) {
            meta |= 8;
            this.setMetaParameter("windowstate", windowState.toString());
        }
        this.setMetaParameter("action", Integer.toHexString(meta));
    }

    private void setMetaParameter(String name, String value) {
        String[] values = this.queryParameters.getValues(name);
        if (values == null) {
            values = new String[]{value};
        } else {
            String[] tmp = new String[values.length + 1];
            System.arraycopy(values, 0, tmp, 1, values.length);
            tmp[0] = value;
            values = tmp;
        }
        this.queryParameters.setValues(name, values);
    }
}

