/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.junit;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class TransactionAssert
extends Assert {
    private static final String[] STATUS_NAMES = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};
    public static final Terminator NONE = new Terminator("NONE");
    public static final Terminator MARKED_AS_ROLLBACK = new Terminator("MARKED_AS_ROLLBACK");
    public static final Terminator MUST_COMMIT = new Terminator("MUST_COMMIT");
    public static final Terminator MUST_ROLLBACK = new Terminator("MUST ROLLBACK");

    public static String decodeStatus(int status) {
        if (status >= 0 && status <= STATUS_NAMES.length) {
            return STATUS_NAMES[status];
        }
        return null;
    }

    public static void assertStatusEquals(int expectedStatus) {
        try {
            UserTransaction ut = TransactionAssert.getUserTransaction();
            int status = ut.getStatus();
            if (status != expectedStatus) {
                TransactionAssert.fail((String)("The status of the current transaction is " + status + " was expecting " + expectedStatus));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAssert.fail((String)"Unexpected exception");
        }
    }

    public static void commitTransaction() {
        try {
            TransactionAssert.getUserTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAssert.fail((String)"Cannot commit transaction");
        }
    }

    public static void rollbackTransaction() {
        TransactionAssert.rollbackTransaction(true);
    }

    public static void rollbackTransaction(boolean marked) {
        try {
            UserTransaction ut = TransactionAssert.getUserTransaction();
            int status = ut.getStatus();
            if (status == 1) {
                ut.rollback();
                if (!marked) {
                    TransactionAssert.fail((String)"Transaction should have been marked as rollback");
                }
            } else if (status == 0) {
                ut.rollback();
                if (marked) {
                    TransactionAssert.fail((String)"Transaction should have been marked as rollback");
                }
            } else if (marked) {
                TransactionAssert.fail((String)("Unexpected transaction status " + status));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAssert.fail((String)"Cannot end transaction");
        }
    }

    public static void beginTransaction() {
        try {
            TransactionAssert.getUserTransaction().begin();
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAssert.fail((String)"Cannot begin transaction");
        }
    }

    public static int endTransaction() {
        try {
            UserTransaction ut = TransactionAssert.getUserTransaction();
            int status = ut.getStatus();
            if (status == 1) {
                ut.rollback();
            } else if (status == 0) {
                ut.commit();
            } else if (status != 6) {
                TransactionAssert.fail((String)("Unexpected transaction status " + status));
            }
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionFailedError("Cannot end transaction");
        }
    }

    public static int endTransaction(Terminator expectedTerminator) {
        if (expectedTerminator == null) {
            throw new IllegalArgumentException();
        }
        try {
            UserTransaction ut = TransactionAssert.getUserTransaction();
            int status = ut.getStatus();
            if (status == 1) {
                ut.rollback();
                if (expectedTerminator != MARKED_AS_ROLLBACK) {
                    TransactionAssert.fail((String)("Was expecting the transaction to be marked as rollback instead got " + TransactionAssert.decodeStatus(status)));
                }
            } else if (status == 0) {
                if (expectedTerminator == MUST_COMMIT) {
                    ut.commit();
                } else if (expectedTerminator == MUST_ROLLBACK) {
                    ut.rollback();
                } else {
                    TransactionAssert.fail((String)("Was expecting the transaction to be either commiting or rollbacking instead got " + TransactionAssert.decodeStatus(status)));
                }
            } else if (status == 6) {
                if (expectedTerminator != NONE) {
                    TransactionAssert.fail((String)("Was expecting no transaction instead got " + TransactionAssert.decodeStatus(status)));
                }
            } else {
                TransactionAssert.fail((String)("Unexpected transaction status " + TransactionAssert.decodeStatus(status)));
            }
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionFailedError("Cannot end transaction");
        }
    }

    public static UserTransaction getUserTransaction() {
        try {
            return (UserTransaction)new InitialContext().lookup("UserTransaction");
        }
        catch (NamingException e) {
            e.printStackTrace();
            TransactionAssert.fail((String)"Cannot obtain user transaction");
            return null;
        }
    }

    public static final class Terminator {
        private final String name;

        public Terminator(String name) {
            this.name = name;
        }
    }
}

