/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.impl;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.io.Serialization;
import org.jboss.portal.common.io.SerializationFilter;
import org.jboss.portal.common.util.Base64;
import org.jboss.portal.common.util.MapAdapters;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.portlet.controller.request.ControllerRequest;
import org.jboss.portal.portlet.controller.request.PortletActionRequest;
import org.jboss.portal.portlet.controller.request.PortletRenderRequest;
import org.jboss.portal.portlet.controller.request.PortletResourceRequest;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.web.Body;
import org.jboss.portal.web.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerRequestFactory {
    private final Serialization<PortletPageNavigationalState> serialization;

    public ControllerRequestFactory(Serialization<PortletPageNavigationalState> serialization) {
        this.serialization = serialization;
    }

    public ControllerRequest decode(WebRequest req) {
        return this.decode((Map<String, String[]>)req.getQueryParameterMap(), req.getBody());
    }

    public ControllerRequest decode(Map<String, String[]> queryParameters, Body body) {
        Map bodyParameters = null;
        if (body instanceof Body.Form) {
            bodyParameters = ((Body.Form)body).getParameters();
        }
        return this.decode(queryParameters, bodyParameters);
    }

    public ControllerRequest decode(Map<String, String[]> queryParameterMap, Map<String, String[]> formParameterMap) {
        Map queryParameters = MapAdapters.adapt(queryParameterMap);
        PortletPageNavigationalState pageNavigationalState = null;
        String context = (String)queryParameters.get("pagenavigationalstate");
        if (context != null) {
            byte[] bytes = Base64.decode((String)context, (boolean)true);
            pageNavigationalState = (PortletPageNavigationalState)IOTools.unserialize(this.serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (byte[])bytes);
        }
        String windowId = (String)queryParameters.get("windowid");
        Mode mode = null;
        if (queryParameters.get("mode") != null) {
            mode = Mode.create((String)((String)queryParameters.get("mode")));
        }
        WindowState windowState = null;
        if (queryParameters.get("windowstate") != null) {
            windowState = WindowState.create((String)((String)queryParameters.get("windowstate")));
        }
        String navigationalStateString = (String)queryParameters.get("navigationalstate");
        StateString navigationalState = null;
        if (navigationalStateString != null) {
            navigationalState = StateString.create((String)navigationalStateString);
        }
        PortletWindowNavigationalState windowNavigationalState = new PortletWindowNavigationalState(navigationalState, mode, windowState);
        String phase = (String)queryParameters.get("phase");
        if ("resource".equals(phase)) {
            PortletResourceRequest.FullScope scope;
            StateString resourceState = StateString.create((String)((String)queryParameters.get("resourcestate")));
            String resourceId = (String)queryParameters.get("resourceid");
            CacheLevel resourceCacheLevel = CacheLevel.valueOf((String)((String)queryParameters.get("resourcecacheability")));
            switch (resourceCacheLevel) {
                case FULL: {
                    scope = new PortletResourceRequest.FullScope();
                    break;
                }
                case PORTLET: {
                    scope = new PortletResourceRequest.PortletScope(windowNavigationalState);
                    break;
                }
                case PAGE: {
                    scope = new PortletResourceRequest.PageScope(windowNavigationalState, pageNavigationalState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return new PortletResourceRequest(windowId, resourceId, resourceState, formParameterMap, scope);
        }
        if ("action".equals(phase)) {
            StateString interactionState = StateString.create((String)((String)queryParameters.get("interactionstate")));
            return new PortletActionRequest(windowId, interactionState, formParameterMap, windowNavigationalState, pageNavigationalState);
        }
        byte[] bytes = Base64.decode((String)((String)queryParameters.get("publicnavigationalstatechanges")), (boolean)true);
        Map publicNavigationalStateChanges = (Map)IOTools.unserialize((Serialization)Serialization.PARAMETER_MAP, (SerializationFilter)SerializationFilter.COMPRESSOR, (byte[])bytes);
        return new PortletRenderRequest(windowId, windowNavigationalState, publicNavigationalStateChanges, pageNavigationalState);
    }
}

