/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.jboss.portal.common.io.Serialization;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.StateString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersStateString
extends StateString
implements Serializable {
    private static final long serialVersionUID = -8529807471117491810L;
    private ParameterMap parameters;

    public static ParametersStateString create() {
        return new ParametersStateString();
    }

    public static ParametersStateString create(Map<String, String[]> parameters) {
        return new ParametersStateString(parameters);
    }

    public static ParametersStateString create(StateString stateString) throws IllegalArgumentException {
        if (stateString == null) {
            throw new IllegalArgumentException("No null state string accepted");
        }
        if (stateString instanceof ParametersStateString) {
            return new ParametersStateString((Map<String, String[]>)((ParametersStateString)stateString).parameters);
        }
        return new ParametersStateString(stateString.getStringValue());
    }

    protected ParametersStateString(DataInputStream in) throws IOException {
        Map tmp = (Map)Serialization.PARAMETER_MAP.unserialize((InputStream)in);
        this.parameters = ParameterMap.wrap((Map)tmp);
    }

    protected ParametersStateString(String opaqueValue) {
        Map<String, String[]> params = StateString.decodeOpaqueValue(opaqueValue);
        this.parameters = !params.isEmpty() ? ParameterMap.wrap(params) : new ParameterMap();
    }

    protected ParametersStateString() {
        this.parameters = new ParameterMap();
    }

    private ParametersStateString(Map<String, String[]> parameters) {
        this.parameters = ParameterMap.clone(parameters);
    }

    public String getValue(String name) throws IllegalArgumentException {
        return this.parameters.getValue(name);
    }

    public String[] getValues(String name) throws IllegalArgumentException {
        return (String[])this.parameters.get((Object)name);
    }

    public void clear() {
        this.parameters.clear();
    }

    public void replace(Map<String, String[]> map) {
        this.parameters.replace(map);
    }

    public void setValue(String name, String value) {
        this.parameters.setValue(name, value);
    }

    public void setValues(String name, String[] values) {
        this.parameters.setValues(name, values);
    }

    public void remove(String name) {
        this.parameters.remove((Object)name);
    }

    public int getSize() {
        return this.parameters.size();
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public String getStringValue() {
        return StateString.encodeAsOpaqueValue((Map<String, String[]>)this.parameters);
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        if (this.parameters.isEmpty()) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            Serialization.PARAMETER_MAP.serialize((Object)this.parameters, (OutputStream)out);
        }
    }

    public String toString() {
        return "StateString[" + this.parameters + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ParametersStateString) {
            ParametersStateString that = (ParametersStateString)obj;
            return this.parameters.equals((Object)that.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }
}

