/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.i18n.ResourceBundleFactory;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.reflect.NoSuchClassException;
import org.jboss.portal.portlet.impl.info.ContainerInfoBuilderContext;
import org.jboss.portal.portlet.impl.jsr168.SimpleResourceBundleFactory;
import org.jboss.portal.portlet.impl.metadata.PortletApplication10MetaData;
import org.jboss.portal.portlet.impl.metadata.PortletApplication20MetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletMetaData;
import org.jboss.portal.web.WebApp;

public class ContainerInfoBuilderContextImpl
implements ContainerInfoBuilderContext {
    private final PortletApplication10MetaData metaData;
    private final WebApp webApp;
    private final Map<String, ResourceBundleManager> portletBundleMgrs;
    private ResourceBundleManager applicationBundleMgr;
    private final String applicationName;

    public ContainerInfoBuilderContextImpl(PortletApplication10MetaData metaData, WebApp webApp) {
        this.metaData = metaData;
        this.webApp = webApp;
        this.portletBundleMgrs = new HashMap<String, ResourceBundleManager>();
        this.applicationName = webApp.getContextPath().substring(1);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ResourceBundleManager getBundleManager() {
        if (this.applicationBundleMgr == null) {
            String baseName = ((PortletApplication20MetaData)this.metaData).getResourceBundle();
            SimpleResourceBundleFactory rbf = new SimpleResourceBundleFactory(this.webApp.getClassLoader(), baseName);
            this.applicationBundleMgr = new ResourceBundleManager(null, (ResourceBundleFactory)rbf);
        }
        return this.applicationBundleMgr;
    }

    public ResourceBundleManager getBundleManager(PortletMetaData portletMD) {
        ResourceBundleManager bundleMgr = this.portletBundleMgrs.get(portletMD.getPortletName());
        if (bundleMgr == null) {
            String baseName = portletMD.getResourceBundle();
            SimpleResourceBundleFactory rbf = new SimpleResourceBundleFactory(this.webApp.getClassLoader(), baseName);
            bundleMgr = new ResourceBundleManager(null, (ResourceBundleFactory)rbf);
            this.portletBundleMgrs.put(portletMD.getPortletName(), bundleMgr);
        }
        return bundleMgr;
    }

    public Class getClass(String className) throws IllegalArgumentException, NoSuchClassException {
        if (className == null) {
            throw new IllegalArgumentException("No null class name accepted");
        }
        try {
            return this.webApp.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchClassException(className, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new NoSuchClassException(className, (Throwable)e);
        }
    }
}

