/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.identity;

import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.QueryConverter;
import org.jboss.portal.search.SearchingException;
import org.jboss.portal.search.impl.AbstractFederatedSearcher;
import org.jboss.portal.search.impl.SimpleQueryConverter;
import org.jboss.portal.search.query.BooleanClause;
import org.jboss.portal.search.query.BooleanQuery;
import org.jboss.portal.search.query.Term;
import org.jboss.portal.search.query.TermQuery;
import org.jboss.portal.search.result.ResultSet;
import org.jboss.portal.search.result.impl.PortletResultURL;
import org.jboss.portal.search.result.impl.SimpleResult;

public class UserSearcher
extends AbstractFederatedSearcher {
    private UserModule userModule;

    public UserSearcher() {
        this.setId("user_searcher");
        this.setDisplayName(new LocalizedString("User Searcher"));
        try {
            this.userModule = (UserModule)new InitialContext().lookup("java:/portal/UserModule");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public ResultSet search(Query query) throws SearchingException {
        ResultSet resultSet = new ResultSet(this);
        this.search(query, resultSet);
        return resultSet;
    }

    private void search(Query query, ResultSet resultSet) {
        if (query instanceof TermQuery) {
            this.searchTerm(((TermQuery)query).getTerm(), resultSet);
        } else if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause clause : booleanQuery.getClauses()) {
                if (clause.isProhibited()) continue;
                this.search(booleanQuery, resultSet);
            }
        }
    }

    private void searchTerm(Term term, ResultSet resultSet) {
        try {
            User user = this.userModule.findUserByUserName(term.getText());
            SimpleResult result = new SimpleResult(this.getId(), user);
            result.setTitle(new LocalizedString(user.getUserName()));
            result.setType(new LocalizedString("User"));
            HashMap<String, String> renderParameters = new HashMap<String, String>();
            renderParameters.put("userid", user.getId().toString());
            renderParameters.put("op", "viewProfile");
            PortletResultURL url = new PortletResultURL("default.default.UserPortletWindow", renderParameters);
            result.setURL(url);
            resultSet.add(result);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchUserException e) {
        }
        catch (IdentityException e) {
            e.printStackTrace();
        }
    }

    public QueryConverter getQueryConverter() {
        return new SimpleQueryConverter();
    }
}

