/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.portlet;

import java.util.ListIterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.common.util.MultiValuedPropertyMap;
import org.jboss.portal.core.aspects.portlet.CorePortletInterceptor;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.impl.spi.AbstractServerContext;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.FragmentResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;

public class HttpHeaderInterceptor
extends CorePortletInterceptor {
    private String defaultCookiePath = null;

    public String getDefaultCookiePath() {
        return this.defaultCookiePath;
    }

    public void setDefaultCookiePath(String defaultCookiePath) {
        this.defaultCookiePath = defaultCookiePath;
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        FragmentResponse fr;
        PortletInvocationResponse response = super.invoke(invocation);
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse unsr = (UpdateNavigationalStateResponse)response;
            if (unsr.getProperties() != null) {
                for (Cookie cookie : unsr.getProperties().getCookies()) {
                    this.addCookie(invocation, cookie);
                }
                this.setHeaders((MultiValuedPropertyMap<String>)unsr.getProperties().getTransportHeaders(), ((AbstractServerContext)invocation.getServerContext()).getResponse());
            }
        } else if (response instanceof FragmentResponse && (fr = (FragmentResponse)response).getProperties() != null) {
            for (Cookie cookie : fr.getProperties().getCookies()) {
                this.addCookie(invocation, cookie);
            }
            this.setHeaders((MultiValuedPropertyMap<String>)fr.getProperties().getTransportHeaders(), ((AbstractServerContext)invocation.getServerContext()).getResponse());
        }
        return response;
    }

    private void addCookie(PortletInvocation invocation, Cookie cookie) {
        if ((cookie.getPath() == null || "".equals(cookie.getPath().trim())) && this.defaultCookiePath != null) {
            cookie.setPath(this.defaultCookiePath);
        }
        ((AbstractServerContext)invocation.getServerContext()).getResponse().addCookie(cookie);
    }

    private void setHeaders(MultiValuedPropertyMap<String> map, HttpServletResponse response) {
        for (String key : map.keySet()) {
            try {
                if (key != null && map.getValue(key) != null) {
                    response.setHeader(key, (String)map.getValue(key));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (map.size() <= 1) continue;
            ListIterator i = map.getValues(key).listIterator(1);
            while (i.hasNext()) {
                String value = (String)i.next();
                response.addHeader(key, value);
            }
        }
    }
}

