/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

public class ExcludedRequestAttribute {
    private final String name;
    private final boolean wildcard;

    public ExcludedRequestAttribute(String name) {
        if (null == name) {
            throw new NullPointerException("Excluded request attribute name is null");
        }
        if (name.endsWith("*")) {
            this.wildcard = true;
            name = name.substring(0, name.length() - 1);
        } else {
            this.wildcard = false;
        }
        this.name = name;
    }

    public boolean match(String attributeName) {
        if (this.wildcard) {
            return attributeName.startsWith(this.name);
        }
        return attributeName.equals(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.wildcard ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcludedRequestAttribute other = (ExcludedRequestAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.wildcard == other.wildcard;
    }
}

