/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.dbline;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.bsf.dbline.BreakPoint;

public class Buffer {
    String m_uri;
    String m_name;
    String m_filename;
    String[] m_lines;
    Vector m_breakpoints;
    int m_currentLine;

    public Buffer(String string, String string2, File file) {
        this.m_filename = string2;
        this.m_lines = this.loadAndParse2(file);
        int n = this.m_filename.lastIndexOf(File.separatorChar);
        this.m_name = this.m_filename.substring(n + 1);
        this.m_uri = string;
        this.m_breakpoints = new Vector();
    }

    public void addBreakpoint(BreakPoint breakPoint) {
        this.m_breakpoints.addElement(breakPoint);
    }

    StringBuffer buildFnOrScript(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.m_lines.length) {
            n2 = this.m_lines.length;
        }
        for (int i = n; i < n2; ++i) {
            String string = this.m_lines[i];
            stringBuffer.append(string + "\n");
        }
        return stringBuffer;
    }

    public static Buffer factory(String string, String string2) {
        Buffer buffer = null;
        char c = File.separatorChar;
        string = string.replace('/', c);
        File file = new File(string = string.trim());
        if (file.exists()) {
            buffer = new Buffer(string2, string, file);
        } else {
            System.out.println("File " + string + " does not exist.");
        }
        return buffer;
    }

    public BreakPoint getBreakpoint(int n) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (breakPoint.m_id != n) continue;
            return breakPoint;
        }
        return null;
    }

    public BreakPoint removeBreakpoint(int n) {
        BreakPoint breakPoint = this.getBreakpoint(n);
        this.m_breakpoints.removeElement(breakPoint);
        return breakPoint;
    }

    public Enumeration getBreakpoints() {
        return this.m_breakpoints.elements();
    }

    public int getCurrentLine() {
        return this.m_currentLine;
    }

    public void setCurrentLine(int n) {
        this.m_currentLine = n;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public int getLineCount() {
        return this.m_lines.length;
    }

    public String getLine(int n) {
        try {
            return this.m_lines[n];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getURI() {
        return this.m_uri;
    }

    private String[] loadAndParse2(File file) {
        Vector<String> vector = new Vector<String>();
        try {
            int n = (int)file.length();
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = fileInputStream.read();
                byArray[n2++] = (byte)n3;
                if (n3 != 10) continue;
                String string = new String(byArray, 0, n2 - 1);
                vector.addElement(string);
                n2 = 0;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        String[] stringArray = new String[vector.size()];
        System.arraycopy(vector.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }
}

