/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jbc.cacheprovider;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.AbstractJndiBoundCacheProvider;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.TreeCache;
import org.jboss.hibernate.jbc.cacheprovider.CacheProperties;
import org.jboss.hibernate.jbc.cacheprovider.JBCCache;
import org.jboss.hibernate.jbc.cacheprovider.OptimisticJBCCache;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerLocator;

public class JndiBoundTreeCacheProvider
extends AbstractJndiBoundCacheProvider {
    private static final Logger log = Logger.getLogger(JndiBoundTreeCacheProvider.class);
    private boolean optimistic;
    private TransactionManager transactionManager;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        CacheProperties cacheProperties = new CacheProperties(properties);
        if (this.optimistic) {
            return new OptimisticJBCCache(this.getUnderlyingCache(), regionName, cacheProperties);
        }
        return new JBCCache(this.getUnderlyingCache(), regionName, cacheProperties, this.transactionManager);
    }

    public void prepare(Properties properties) throws CacheException {
        TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup((Properties)properties);
        this.transactionManager = transactionManagerLookup != null ? transactionManagerLookup.getTransactionManager(properties) : TransactionManagerLocator.getInstance().locate();
        if ("OPTIMISTIC".equals(this.getUnderlyingCache().getNodeLockingScheme())) {
            this.optimistic = true;
            log.debug((Object)"JBoss Cache is configured for optimistic locking; provided Cache implementations will also implement OptimisticCache");
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }

    public TreeCache getUnderlyingCache() {
        return (TreeCache)super.getCache();
    }
}

